/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.core.option.OptionUtils;
import adams.flow.source.AbstractSelectObjects;
import adams.gui.goe.GenericArrayEditorDialog;
import java.awt.Dialog;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class SelectObjects
extends AbstractSelectObjects {
    private static final long serialVersionUID = 8941008707409028350L;
    protected GenericArrayEditorDialog m_Dialog;

    @Override
    public String globalInfo() {
        return "Allows the user to select an arbitrary number of objects from the specified class hierarchy using the GenericObjectArray.";
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, the objects get output as array rather than one-by-one.";
    }

    @Override
    protected Class getItemClass() {
        try {
            return this.m_SuperClass.classValue();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    protected Object commandlineToObject(String cmdline) {
        try {
            return OptionUtils.forAnyCommandLine(this.getItemClass(), cmdline);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to convert commandline: " + cmdline, e);
            return null;
        }
    }

    @Override
    protected void initializeDialog() {
        if (this.m_Dialog == null) {
            this.m_Dialog = new GenericArrayEditorDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
            if (this.m_ShortTitle) {
                this.m_Dialog.setTitle(this.getName());
            } else {
                this.m_Dialog.setTitle(this.getFullName());
            }
            this.m_Dialog.setLocationRelativeTo(null);
            this.m_Dialog.setOkAlwaysEnabled(true);
        }
        ArrayList<Object> current = new ArrayList<Object>();
        for (BaseString initial : this.m_InitialObjects) {
            Object obj = this.commandlineToObject(initial.getValue());
            if (obj == null) {
                this.getLogger().warning("Failed to convert commandline: " + initial);
            }
            current.add(obj);
        }
        Object array = Array.newInstance(this.getItemClass(), current.size());
        for (int i = 0; i < current.size(); ++i) {
            Array.set(array, i, current.get(i));
        }
        this.m_Dialog.setCurrent(array);
    }

    @Override
    protected Object[] showDialog() {
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getResult() != 0) {
            return null;
        }
        Object array = this.m_Dialog.getCurrent();
        Object[] result = new Object[Array.getLength(array)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Array.get(array, i);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        if (this.m_Dialog != null) {
            this.m_Dialog.setVisible(false);
        }
        super.stopExecution();
    }

    @Override
    public void wrapUp() {
        if (this.m_Dialog != null) {
            final GenericArrayEditorDialog dialog = this.m_Dialog;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                }
            };
            this.m_Dialog = null;
            SwingUtilities.invokeLater(run);
        }
        super.wrapUp();
    }
}

