/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source.newlist;

import adams.core.QuickInfoHelper;
import adams.flow.source.newlist.AbstractListGenerator;
import java.util.ArrayList;
import java.util.List;

public class ForLoop
extends AbstractListGenerator {
    private static final long serialVersionUID = -4623795710416726074L;
    protected int m_LoopLower;
    protected int m_LoopUpper;
    protected int m_LoopStep;

    @Override
    public String globalInfo() {
        return "Emulates the following for-loop for integer IDs:\n- positive step size:\n  for (int i = lower; i <= upper; i += step)\n- negative step size:\n  for (int i = upper; i >= lower; i += step)";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("lower", "loopLower", 1);
        this.m_OptionManager.add("upper", "loopUpper", 10);
        this.m_OptionManager.add("step", "loopStep", 1);
    }

    public void setLoopLower(int value) {
        this.m_LoopLower = value;
        this.reset();
    }

    public int getLoopLower() {
        return this.m_LoopLower;
    }

    public String loopLowerTipText() {
        return "The lower bound of the loop (= the first value).";
    }

    public void setLoopUpper(int value) {
        this.m_LoopUpper = value;
        this.reset();
    }

    public int getLoopUpper() {
        return this.m_LoopUpper;
    }

    public String loopUpperTipText() {
        return "The upper bound of the loop.";
    }

    public void setLoopStep(int value) {
        this.m_LoopStep = value;
        this.reset();
    }

    public int getLoopStep() {
        return this.m_LoopStep;
    }

    public String loopStepTipText() {
        return "The step size of the loop.";
    }

    @Override
    protected void check() throws Exception {
        super.check();
        if (this.m_LoopStep == 0) {
            throw new IllegalStateException("Step size must be either greater or smaller than 0!");
        }
        if (this.m_LoopLower > this.m_LoopUpper && this.m_LoopStep > 0) {
            throw new IllegalStateException("Lower bound cannot be larger than upper bound!");
        }
        if (this.m_LoopLower < this.m_LoopUpper && this.m_LoopStep < 0) {
            throw new IllegalStateException("Upper bound cannot be larger than lower bound!");
        }
    }

    @Override
    public String getQuickInfo() {
        String loopStep = QuickInfoHelper.getVariable(this, "loopStep");
        String loopLower = QuickInfoHelper.getVariable(this, "loopLower");
        String loopUpper = QuickInfoHelper.getVariable(this, "loopUpper");
        if (this.m_LoopStep >= 0 || loopStep != null) {
            return "for (i = " + (loopLower == null ? Integer.valueOf(this.m_LoopLower) : loopLower) + "; " + "i <= " + (loopUpper == null ? Integer.valueOf(this.m_LoopUpper) : loopUpper) + "; " + "i += " + (loopStep == null ? Integer.valueOf(this.m_LoopStep) : loopStep) + ")";
        }
        return "for (i = " + (loopUpper == null ? Integer.valueOf(this.m_LoopUpper) : loopUpper) + "; " + "i >= " + (loopLower == null ? Integer.valueOf(this.m_LoopLower) : loopLower) + "; " + "i += " + (loopStep == null ? Integer.valueOf(this.m_LoopStep) : loopStep) + ")";
    }

    @Override
    protected List<String> doGenerate() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (this.m_LoopStep > 0) {
            for (int i = this.m_LoopLower; i <= this.m_LoopUpper; i += this.m_LoopStep) {
                result.add("" + i);
            }
        } else {
            for (int i = this.m_LoopLower; i >= this.m_LoopUpper; i += this.m_LoopStep) {
                result.add("" + i);
            }
        }
        return result;
    }
}

