/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.Variables;
import adams.core.io.FlowFile;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.RunnableWithLogging;
import java.util.ArrayList;
import java.util.List;

public class ExternalFlow
extends AbstractActor {
    private static final long serialVersionUID = 6212392783858480058L;
    protected FlowFile m_FlowFile;
    protected ExecutionType m_ExecutionType;
    protected AbstractActor m_ExternalFlow;
    protected Boolean m_FlowFileIsVariable;
    protected String m_FlowFileVariable;
    protected boolean m_FlowFileChanged;
    protected List<RunnableWithLogging> m_Asynchronous;

    @Override
    public String globalInfo() {
        return "Allows to execute a complete external Flow rather than just an external actor.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "flowFile", new FlowFile("."));
        this.m_OptionManager.add("execution-type", "executionType", (Object)ExecutionType.SYNCHRONOUS);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Asynchronous = new ArrayList<RunnableWithLogging>();
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "flowFile", this.m_FlowFile, "file: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "executionType", (Object)this.m_ExecutionType, ", execution: ");
        return result;
    }

    public void setFlowFile(FlowFile value) {
        this.m_FlowFile = value;
        this.reset();
    }

    public FlowFile getFlowFile() {
        return this.m_FlowFile;
    }

    public String flowFileTipText() {
        return "The file containing the external flow.";
    }

    public void setExecutionType(ExecutionType value) {
        this.m_ExecutionType = value;
        this.reset();
    }

    public ExecutionType getExecutionType() {
        return this.m_ExecutionType;
    }

    public String executionTypeTipText() {
        return "Determines how the flow is executed.";
    }

    @Override
    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (this.m_FlowFileIsVariable == null) {
            this.m_FlowFileVariable = this.getOptionManager().getVariableForProperty("flowFile");
            this.m_FlowFileIsVariable = this.m_FlowFileVariable != null;
            if (this.m_FlowFileIsVariable.booleanValue()) {
                this.m_FlowFileVariable = Variables.extractName(this.m_FlowFileVariable);
            }
        }
        if (this.m_FlowFileIsVariable.booleanValue() && e.getName().equals(this.m_FlowFileVariable)) {
            this.m_FlowFileChanged = e.getType() != VariableChangeEvent.Type.REMOVED;
        }
    }

    public String setUpExternalActor() {
        String result = null;
        if (!this.m_FlowFile.isFile()) {
            result = "'" + this.m_FlowFile.getAbsolutePath() + "' does not point to a file!";
        } else {
            ArrayList<String> errors = new ArrayList<String>();
            this.m_ExternalFlow = ActorUtils.read(this.m_FlowFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                result = "Error loading external flow '" + this.m_FlowFile.getAbsolutePath() + "':\n" + Utils.flatten(errors, "\n");
            } else if (this.m_ExternalFlow == null) {
                result = "Error loading external flow '" + this.m_FlowFile.getAbsolutePath() + "'!";
            } else {
                this.m_ExternalFlow = ActorUtils.removeDisabledActors(this.m_ExternalFlow);
                result = this.m_ExternalFlow.setUp();
            }
        }
        this.m_FlowFileChanged = false;
        return result;
    }

    public void cleanUpExternalActor() {
        if (this.m_FlowFileChanged && this.m_ExternalFlow != null) {
            this.m_ExternalFlow.wrapUp();
            this.m_ExternalFlow.cleanUp();
            this.m_ExternalFlow = null;
        }
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.cleanUpExternalActor();
            if (this.getOptionManager().getVariableForProperty("flowFile") == null && this.m_ExternalFlow == null) {
                result = this.setUpExternalActor();
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.cleanUpExternalActor();
        if (this.m_ExternalFlow == null) {
            result = this.setUpExternalActor();
        }
        if (result == null) {
            switch (this.m_ExecutionType) {
                case SYNCHRONOUS: {
                    result = this.m_ExternalFlow.execute();
                    break;
                }
                case SYNCHRONOUS_IMMEDIATE_CLEANUP: {
                    result = this.m_ExternalFlow.execute();
                    this.m_ExternalFlow.wrapUp();
                    this.m_ExternalFlow.destroy();
                    this.m_ExternalFlow = null;
                    break;
                }
                case ASYNCHRONOUS: {
                    RunnableWithLogging run = new RunnableWithLogging(){
                        private static final long serialVersionUID = -3439650903854980640L;

                        @Override
                        protected void doRun() {
                            ExternalFlow.this.m_ExternalFlow.execute();
                            ExternalFlow.this.m_Asynchronous.remove(this);
                        }

                        @Override
                        public void stopExecution() {
                            ExternalFlow.this.m_ExternalFlow.stopExecution();
                            super.stopExecution();
                        }
                    };
                    this.m_Asynchronous.add(run);
                    new Thread(run).start();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled execution type: " + (Object)((Object)this.m_ExecutionType));
                }
            }
        }
        return result;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        if (this.m_ExternalFlow != null) {
            this.m_ExternalFlow.stopExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapUp() {
        if (this.m_ExternalFlow != null) {
            switch (this.m_ExecutionType) {
                case SYNCHRONOUS: {
                    this.m_ExternalFlow.wrapUp();
                    break;
                }
                case SYNCHRONOUS_IMMEDIATE_CLEANUP: {
                    break;
                }
                case ASYNCHRONOUS: {
                    while (this.m_Asynchronous.size() > 0) {
                        try {
                            ExternalFlow externalFlow = this;
                            synchronized (externalFlow) {
                                this.wait(100L);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled execution type: " + (Object)((Object)this.m_ExecutionType));
                }
            }
        }
        this.m_FlowFileIsVariable = null;
        this.m_FlowFileVariable = null;
        this.m_FlowFileChanged = false;
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        if (this.m_ExternalFlow != null) {
            this.m_ExternalFlow.destroy();
            this.m_ExternalFlow = null;
        }
        super.cleanUp();
    }

    public static enum ExecutionType {
        SYNCHRONOUS,
        SYNCHRONOUS_IMMEDIATE_CLEANUP,
        ASYNCHRONOUS;

    }
}

