/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.goe.PropertyPath;

public class GetObjectProperty
extends AbstractTransformer {
    private static final long serialVersionUID = -6237324482439105653L;
    protected String m_Path;

    @Override
    public String globalInfo() {
        return "Retrieves a value from an object's property using a bean property path.\nA bean property conists usually of a get and set method, e.g.:\n- setDebug(boolean)\n- boolean getDebug()\nThe property name for this pair is:\n  debug";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", "");
    }

    public void setPath(String value) {
        this.m_Path = value;
        this.reset();
    }

    public String getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The property path of the object to retrieve.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "path", this.m_Path);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object obj = this.m_InputToken.getPayload();
        Object value = PropertyPath.getValue(obj, this.m_Path);
        if (value == null) {
            result = "Failed to find property: " + this.m_Path;
        } else {
            this.m_OutputToken = new Token(value);
        }
        return result;
    }
}

