/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.goe.PropertyPath;

public class GetProperty
extends AbstractTransformer {
    private static final long serialVersionUID = 597361990633872666L;
    protected String m_Property;

    @Override
    public String globalInfo() {
        return "Obtains the current property value of the object passing through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("property", "property", "");
    }

    public void setProperty(String value) {
        this.m_Property = value;
        this.reset();
    }

    public String getProperty() {
        return this.m_Property;
    }

    public String propertyTipText() {
        return "The property to retrieve the current value for.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "property", this.m_Property, "property: ");
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object obj = this.m_InputToken.getPayload();
            Object value = PropertyPath.getValue(obj, this.m_Property);
            if (value != null) {
                this.m_OutputToken = new Token(value);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to get property: " + this.m_Property, e);
        }
        return result;
    }
}

