/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.transformer.AbstractStringOperation;

public class StringSanitizer
extends AbstractStringOperation {
    private static final long serialVersionUID = 1359563281659205366L;
    protected String m_AcceptableChars;
    protected String m_ReplacementChar;
    protected boolean m_InvertMatching;

    @Override
    public String globalInfo() {
        return "Removes all characters that haven't been specified as 'acceptable' characters. The matching sense can also be inverted, i.e., 'acceptable' characters become 'outlawed' ones.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("acceptable", "acceptableChars", "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-");
        this.m_OptionManager.add("replace", "replacementChar", "");
        this.m_OptionManager.add("V", "invertMatching", false);
    }

    public void setAcceptableChars(String value) {
        this.m_AcceptableChars = value;
        this.reset();
    }

    public String getAcceptableChars() {
        return this.m_AcceptableChars;
    }

    public String acceptableCharsTipText() {
        return "The allowed characters, all others will get removed (or replaced).";
    }

    public void setReplacementChar(String value) {
        if (value.length() <= 1) {
            this.m_ReplacementChar = value;
            this.reset();
        } else {
            this.getLogger().severe("Either empty string or a single character are allowed, provided: " + value);
        }
    }

    public String getReplacementChar() {
        return this.m_ReplacementChar;
    }

    public String replacementCharTipText() {
        return "The character to replace the 'unacceptable' characters with; use the empty string if you want to remove 'unacceptable' characters.";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "If set to true, then 'acceptable' characters will become 'outlaws', ie, replaced or removed.";
    }

    @Override
    protected String process(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (this.m_InvertMatching) {
                if (this.m_AcceptableChars.indexOf(ch) > -1) {
                    result.append(this.m_ReplacementChar);
                    continue;
                }
                result.append(ch);
                continue;
            }
            if (this.m_AcceptableChars.indexOf(ch) > -1) {
                result.append(ch);
                continue;
            }
            result.append(this.m_ReplacementChar);
        }
        return result.toString();
    }
}

