/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;

public class SubStringCount
extends AbstractTransformer {
    private static final long serialVersionUID = -3687113148170774846L;
    protected String m_Find;
    protected Index m_FromIndex;
    protected boolean m_CaseSensitive;
    protected boolean m_Backward;

    @Override
    public String globalInfo() {
        return "Determines the position of a substring in the string passing through.\nThe generated index is 1-based, with 0 indicating that the substring could not be located.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("find", "find", "");
        this.m_OptionManager.add("from-index", "fromIndex", new Index("first"));
        this.m_OptionManager.add("case-sensitive", "caseSensitive", true);
        this.m_OptionManager.add("backward", "backward", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "find", this.m_Find, "find: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "fromIndex", this.m_FromIndex, ", from: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "caseSensitive", this.m_CaseSensitive, "case-sensitive"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "backward", this.m_Backward, "backward"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setFind(String value) {
        this.m_Find = value;
        this.reset();
    }

    public String getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The sub-string to look for.";
    }

    public void setFromIndex(Index value) {
        this.m_FromIndex = value;
        this.reset();
    }

    public Index getFromIndex() {
        return this.m_FromIndex;
    }

    public String fromIndexTipText() {
        return "The index to start the search from.";
    }

    public void setCaseSensitive(boolean value) {
        this.m_CaseSensitive = value;
        this.reset();
    }

    public boolean getCaseSensitive() {
        return this.m_CaseSensitive;
    }

    public String caseSensitiveTipText() {
        return "If enabled, a case-sensitive search is performed.";
    }

    public void setBackward(boolean value) {
        this.m_Backward = value;
        this.reset();
    }

    public boolean getBackward() {
        return this.m_Backward;
    }

    public String backwardTipText() {
        return "If enabled, the search starts from the back rather than from the start of the string.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        String str = (String)this.m_InputToken.getPayload();
        String find = this.m_Find;
        if (!this.m_CaseSensitive) {
            str = str.toLowerCase();
            find = find.toLowerCase();
        }
        this.m_FromIndex.setMax(str.length());
        int from = this.m_FromIndex.getIntIndex();
        int count = 0;
        while (from > -1) {
            if (this.m_Backward) {
                if ((from = str.lastIndexOf(find, from)) == -1) continue;
                --from;
                ++count;
                continue;
            }
            if ((from = str.indexOf(find, from)) == -1) continue;
            ++from;
            ++count;
        }
        this.m_OutputToken = new Token(count);
        return result;
    }
}

