/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.splitfile;

import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFileSplitter
extends AbstractOptionHandler
implements Stoppable {
    private static final long serialVersionUID = 929718454245646770L;
    protected PlaceholderFile m_Prefix;
    protected String m_Extension;
    protected int m_NumDigits;
    protected boolean m_Stopped;
    protected List<File> m_Generated;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", new PlaceholderFile("./split"));
        this.m_OptionManager.add("extension", "extension", ".bin");
        this.m_OptionManager.add("num-digits", "numDigits", 3, 1, null);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Generated = new ArrayList<File>();
    }

    public void setPrefix(PlaceholderFile value) {
        this.m_Prefix = value;
        this.reset();
    }

    public PlaceholderFile getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix for the generated files.";
    }

    public void setExtension(String value) {
        this.m_Extension = value;
        this.reset();
    }

    public String getExtension() {
        return this.m_Extension;
    }

    public String extensionTipText() {
        return "The file extension to use.";
    }

    public void setNumDigits(int value) {
        this.m_NumDigits = value;
        this.reset();
    }

    public int getNumDigits() {
        return this.m_NumDigits;
    }

    public String numDigitsTipText() {
        return "The number of digits to use for the index of the generated files.";
    }

    protected void check(PlaceholderFile file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory: " + file);
        }
    }

    protected File nextFile() {
        String file = this.m_Prefix.getAbsolutePath();
        file = file + Utils.padLeft("" + (this.m_Generated.size() + 1), '0', this.m_NumDigits);
        file = file + this.m_Extension;
        PlaceholderFile result = new PlaceholderFile(file);
        this.m_Generated.add(result);
        return result;
    }

    protected abstract void doSplit(PlaceholderFile var1);

    public String[] split(PlaceholderFile file) {
        String[] result;
        this.m_Stopped = false;
        this.m_Generated.clear();
        this.check(file);
        this.doSplit(file);
        if (this.m_Stopped) {
            result = new String[]{};
        } else {
            result = new String[this.m_Generated.size()];
            for (int i = 0; i < this.m_Generated.size(); ++i) {
                result[i] = this.m_Generated.get(i).getAbsolutePath();
            }
        }
        return result;
    }

    @Override
    public void stopExecution() {
        this.m_Stopped = true;
    }
}

