/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.logging.LoggingObject;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ApplicationMenu
extends LoggingObject
implements Serializable {
    private static final long serialVersionUID = 7821913342345552227L;
    public static final String LAYOUT_MENUBAR = "MenuBar";
    public static final String LAYOUT_AUTOMATICDISCOVERY = "AutomaticMenuItemDiscovery";
    public static final String LAYOUT_MENU_PREFIX = "Menu-";
    public static final String LAYOUT_SHORTCUT_PREFIX = "Shortcut-";
    public static final String LAYOUT_BLACKLISTED_PREFIX = "Blacklisted-";
    public static final String LAYOUT_MENU_WINDOWS = "Windows";
    public static final String LAYOUT_MENU_TOOLS = "Tools";
    public static final String SEPARATOR = "#";
    protected static HashSet<String> m_UnavailableMenuItems;
    protected AbstractApplicationFrame m_Owner;
    protected String m_Setup;
    protected Properties m_Properties;
    protected UserMode m_UserMode;
    protected JMenu m_MenuWindows;

    public ApplicationMenu(AbstractApplicationFrame owner) {
        if (m_UnavailableMenuItems == null) {
            m_UnavailableMenuItems = new HashSet();
        }
        this.m_Owner = owner;
        this.m_Setup = null;
        this.m_UserMode = UserMode.BASIC;
        this.m_MenuWindows = null;
        this.m_Properties = null;
    }

    public AbstractApplicationFrame getOwner() {
        return this.m_Owner;
    }

    public void setSetup(String value) {
        this.m_Setup = value;
    }

    public String getSetup() {
        return this.m_Setup;
    }

    public void setUserMode(UserMode value) {
        this.m_UserMode = value;
    }

    public UserMode getUserMode() {
        return this.m_UserMode;
    }

    protected synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            try {
                this.m_Properties = Properties.read(this.m_Setup);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load menu setup file!", e);
            }
        }
        return this.m_Properties;
    }

    protected int determineItemIndex(String[] items, JMenu menu) {
        int i;
        int result = -1;
        for (i = 0; i < items.length; ++i) {
            items[i] = items[i].toLowerCase();
        }
        for (i = 0; i < menu.getMenuComponentCount(); ++i) {
            if (menu.getMenuComponent(i) instanceof JMenuItem) {
                String text = ((JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase();
                for (String item : items) {
                    if (!text.matches(item)) continue;
                    result = i;
                    break;
                }
            }
            if (result != -1) break;
        }
        return result;
    }

    public JMenuBar getMenuBar() {
        JMenuItem menuitem;
        AbstractMenuItemDefinition definition;
        Constructor<?> constr;
        Class<?> cls;
        String classname;
        int i;
        if (this.m_Setup == null) {
            throw new IllegalStateException("No menu setup file provided!");
        }
        JMenuBar result = new JMenuBar();
        Properties props = this.getProperties();
        boolean autoDiscovery = props.getBoolean(LAYOUT_AUTOMATICDISCOVERY, false);
        HashSet<String> additional = new HashSet<String>(Arrays.asList(AbstractMenuItemDefinition.getMenuItemDefinitions()));
        String[] items = props.getProperty(LAYOUT_MENUBAR, "").split(",");
        char[] mnemonics = GUIHelper.getMnemonics(items);
        JMenu[] menus = new JMenu[items.length];
        boolean[] separators = new boolean[items.length];
        int indexToolsMenu = -1;
        HashSet<String> listAdded = new HashSet<String>();
        for (i = 0; i < items.length; ++i) {
            if (items[i].length() == 0) continue;
            menus[i] = new JMenu(items[i]);
            menus[i].setMnemonic(mnemonics[i]);
            menus[i].setVisible(false);
            if (items[i].equals(LAYOUT_MENU_WINDOWS)) {
                this.m_MenuWindows = menus[i];
                this.m_MenuWindows.setVisible(false);
            }
            if (items[i].equals(LAYOUT_MENU_TOOLS)) {
                indexToolsMenu = i;
            }
            result.add(menus[i]);
        }
        for (i = 0; i < menus.length; ++i) {
            int n;
            items = props.getProperty(LAYOUT_MENU_PREFIX + menus[i].getText(), "").split(",");
            boolean addSeparator = false;
            for (n = 0; n < items.length; ++n) {
                if (items[n].length() == 0 || this.isBlacklisted(items[n]) || this.isUnavailable(items[n])) continue;
                if (items[n].equals("-")) {
                    addSeparator = true;
                    continue;
                }
                try {
                    classname = items[n];
                    String title = null;
                    if (listAdded.contains(classname)) continue;
                    listAdded.add(classname);
                    if (classname.indexOf(SEPARATOR) > -1) {
                        title = classname.substring(classname.indexOf(SEPARATOR) + 1);
                        classname = classname.substring(0, classname.indexOf(SEPARATOR));
                    }
                    additional.remove(classname);
                    if (this.isUnavailable(classname)) continue;
                    String shortcut = null;
                    if (props.hasKey(LAYOUT_SHORTCUT_PREFIX + items[n])) {
                        shortcut = props.getProperty(LAYOUT_SHORTCUT_PREFIX + items[n]);
                    }
                    try {
                        cls = Class.forName(classname);
                    }
                    catch (ClassNotFoundException e) {
                        this.getLogger().severe("Menu item not found, skipping: " + classname);
                        this.setUnavailable(classname);
                        continue;
                    }
                    constr = cls.getConstructor(AbstractApplicationFrame.class);
                    definition = (AbstractMenuItemDefinition)constr.newInstance(this.getOwner());
                    if (this.m_UserMode.compareTo(definition.getUserMode()) < 0 || definition.requiresRestartableApplication() && !this.m_Owner.getEnableRestart()) continue;
                    menus[i].setVisible(true);
                    menuitem = definition.getMenuItem();
                    if (menuitem == null) continue;
                    if (!(menuitem instanceof JMenu)) {
                        if (shortcut != null) {
                            menuitem.setAccelerator(GUIHelper.getKeyStroke(shortcut));
                        } else {
                            menuitem.setAccelerator(null);
                        }
                    }
                    if (title != null) {
                        menuitem.setText(title);
                    }
                    if (addSeparator) {
                        menus[i].addSeparator();
                    }
                    menus[i].add(menuitem);
                    addSeparator = false;
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error processing menu item '" + items[n] + "' " + "for menu '" + menus[i].getText() + "':", e);
                }
            }
            items = new String[menus[i].getItemCount()];
            for (n = 0; n < menus[i].getItemCount(); ++n) {
                items[n] = menus[i].getItem(n) instanceof JMenuItem ? menus[i].getItem(n).getText() : "";
            }
            mnemonics = GUIHelper.getMnemonics(items);
            for (n = 0; n < menus[i].getItemCount(); ++n) {
                if (!(menus[i].getItem(n) instanceof JMenuItem)) continue;
                menus[i].getItem(n).setMnemonic(mnemonics[n]);
            }
        }
        if (autoDiscovery) {
            Enumeration<String> keys = props.propertyNames("Blacklisted-.*");
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!props.getBoolean(key, false).booleanValue()) continue;
                classname = key.substring(LAYOUT_BLACKLISTED_PREFIX.length());
                additional.remove(classname);
            }
            ArrayList<String> additionalList = new ArrayList<String>(additional);
            Collections.sort(additionalList);
            for (String add : additionalList) {
                try {
                    cls = Class.forName(add);
                    constr = cls.getConstructor(AbstractApplicationFrame.class);
                    definition = (AbstractMenuItemDefinition)constr.newInstance(this.getOwner());
                    if (this.m_UserMode.compareTo(definition.getUserMode()) < 0) continue;
                    menuitem = definition.getMenuItem();
                    boolean added = false;
                    for (i = 0; i < menus.length; ++i) {
                        int indexLast;
                        if (!menus[i].getText().equals(definition.getCategory())) continue;
                        added = true;
                        menus[i].setVisible(true);
                        if (menus[i].getMenuComponentCount() > 0 && (indexLast = this.determineItemIndex(new String[]{"restart.*", "exit", "close"}, menus[i])) != -1) {
                            menus[i].insertSeparator(indexLast);
                            menus[i].insert(menuitem, indexLast);
                            continue;
                        }
                        if (!separators[i] && menus[i].getMenuComponentCount() > 0) {
                            menus[i].addSeparator();
                            separators[i] = true;
                        }
                        menus[i].add(menuitem);
                    }
                    if (added) continue;
                    for (i = 0; i < result.getMenuCount(); ++i) {
                        if (!result.getMenu(i).getText().equals(definition.getCategory())) continue;
                        added = true;
                        result.getMenu(i).add(menuitem);
                    }
                    if (added) continue;
                    JMenu menu = new JMenu(definition.getCategory());
                    menu.add(menuitem);
                    if (indexToolsMenu == -1) {
                        result.add(menu);
                    } else {
                        result.add((Component)menu, indexToolsMenu);
                        ++indexToolsMenu;
                    }
                    added = true;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Error processing additional menu item '" + add + "':", e);
                }
            }
        }
        return result;
    }

    public void setBlacklisted(Class cls, boolean value) {
        this.setBlacklisted(cls.getName(), value);
    }

    public void setBlacklisted(String classname, boolean value) {
        Properties props = this.getProperties();
        String key = LAYOUT_BLACKLISTED_PREFIX + classname;
        props.setBoolean(key, value);
    }

    public boolean isBlacklisted(Class cls) {
        return this.isBlacklisted(cls.getName());
    }

    public boolean isBlacklisted(String classname) {
        Properties props = this.getProperties();
        String key = LAYOUT_BLACKLISTED_PREFIX + classname;
        boolean result = props.getBoolean(key, false);
        return result;
    }

    public boolean isUnavailable(Class cls) {
        return this.isUnavailable(cls.getName());
    }

    public boolean isUnavailable(String classname) {
        return m_UnavailableMenuItems.contains(classname);
    }

    public void setUnavailable(Class cls) {
        this.setUnavailable(cls.getName());
    }

    public void setUnavailable(String classname) {
        m_UnavailableMenuItems.add(classname);
    }

    public JMenu getWindowsMenu() {
        return this.m_MenuWindows;
    }
}

