/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDataContainerFileChooser<T extends DataContainer, R extends AbstractDataContainerReader, W extends AbstractDataContainerWriter>
extends AbstractConfigurableExtensionFileFilterFileChooser<R, W> {
    private static final long serialVersionUID = -5373058011025481738L;
    protected static Hashtable<Class, List<ExtensionFileFilterWithClass>> m_ReaderFileFilters = new Hashtable();
    protected static Hashtable<Class, List<ExtensionFileFilterWithClass>> m_WriterFileFilters = new Hashtable();

    protected AbstractDataContainerFileChooser() {
    }

    protected AbstractDataContainerFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractDataContainerFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    protected static void initFilters(AbstractDataContainerFileChooser chooser, boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters.put(chooser.getClass(), new ArrayList());
        } else {
            m_WriterFileFilters.put(chooser.getClass(), new ArrayList());
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractDataContainerReader)converter).getFormatDescription();
                    ext = ((AbstractDataContainerReader)converter).getFormatExtensions();
                } else {
                    desc = ((AbstractDataContainerWriter)converter).getFormatDescription();
                    ext = ((AbstractDataContainerWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.get(chooser.getClass()).add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.get(chooser.getClass()).add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters.get(chooser.getClass()));
        } else {
            Collections.sort(m_WriterFileFilters.get(chooser.getClass()));
        }
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters.get(this.getClass());
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters.get(this.getClass());
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            boolean onlyFiles = this.m_DialogType == 0 ? ((AbstractDataContainerReader)this.m_CurrentHandler).isInputFile() : ((AbstractDataContainerWriter)this.m_CurrentHandler).isOutputFile();
            if (onlyFiles) {
                this.setFileSelectionMode(0);
            } else {
                this.setFileSelectionMode(1);
            }
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    @Override
    protected void configureCurrentHandlerHook(int dialogType) {
        boolean onlyFiles;
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (this.m_CurrentHandler == null) {
            String classname = ((ExtensionFileFilterWithClass)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
        if ((onlyFiles = this.m_CurrentHandler instanceof AbstractDataContainerReader ? ((AbstractDataContainerReader)this.m_CurrentHandler).isInputFile() : ((AbstractDataContainerWriter)this.m_CurrentHandler).isOutputFile()) && selFile.isDirectory() || !onlyFiles && !selFile.isDirectory()) {
            return;
        }
        try {
            PlaceholderFile currFile = this.m_CurrentHandler instanceof AbstractDataContainerReader ? ((AbstractDataContainerReader)this.m_CurrentHandler).getInput() : ((AbstractDataContainerWriter)this.m_CurrentHandler).getOutput();
            if (currFile == null || !((File)currFile).getAbsolutePath().equals(selFile.getAbsolutePath())) {
                if (this.m_CurrentHandler instanceof AbstractDataContainerReader) {
                    ((AbstractDataContainerReader)this.m_CurrentHandler).setInput(selFile);
                } else {
                    ((AbstractDataContainerWriter)this.m_CurrentHandler).setOutput(selFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters.containsKey(this.getClass());
    }

    @Override
    public void setAllowGlobFilters(boolean value) {
    }
}

