/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Placeholders;
import adams.core.io.PlaceholderFile;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.BaseFileChooser;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileChooserPanel
extends AbstractChooserPanel<File> {
    private static final long serialVersionUID = -8755020252465094120L;
    protected BaseFileChooser m_FileChooser;
    protected boolean m_UseSaveDialog;

    public FileChooserPanel() {
        this("");
    }

    public FileChooserPanel(String path) {
        this(new PlaceholderFile(path));
    }

    public FileChooserPanel(File path) {
        this.setCurrent(path);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_UseSaveDialog = false;
    }

    @Override
    protected File doChoose() {
        this.m_FileChooser.setSelectedFile((File)this.getCurrent());
        if (this.m_UseSaveDialog) {
            if (this.m_FileChooser.showSaveDialog(this.m_Self) == 0) {
                return this.m_FileChooser.getSelectedFile();
            }
            return null;
        }
        if (this.m_FileChooser.showOpenDialog(this.m_Self) == 0) {
            return this.m_FileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected String toString(File value) {
        return Placeholders.collapseStr(value.getAbsolutePath());
    }

    @Override
    protected File fromString(String value) {
        return new PlaceholderFile(value);
    }

    public void setFileSelectionMode(int value) {
        this.m_FileChooser.setFileSelectionMode(value);
    }

    public int getFileSelectionMode() {
        return this.m_FileChooser.getFileSelectionMode();
    }

    public void addChoosableFileFilter(FileFilter value) {
        FileFilter current = this.m_FileChooser.getFileFilter();
        this.m_FileChooser.addChoosableFileFilter(value);
        this.m_FileChooser.setFileFilter(current);
    }

    public void removeChoosableFileFilter(FileFilter value) {
        this.m_FileChooser.removeChoosableFileFilter(value);
    }

    public void removeChoosableFileFilters() {
        FileFilter[] filters;
        for (FileFilter filter : filters = this.m_FileChooser.getChoosableFileFilters()) {
            this.m_FileChooser.removeChoosableFileFilter(filter);
        }
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.m_FileChooser.getChoosableFileFilters();
    }

    public void setAcceptAllFileFilterUsed(boolean value) {
        this.m_FileChooser.setAcceptAllFileFilterUsed(value);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.m_FileChooser.isAcceptAllFileFilterUsed();
    }

    public void setFileFilter(FileFilter value) {
        this.m_FileChooser.setFileFilter(value);
    }

    public FileFilter getFileFilter() {
        return this.m_FileChooser.getFileFilter();
    }

    public void setPromptOverwriteFile(boolean value) {
        this.m_FileChooser.setPromptOverwriteFile(value);
    }

    public boolean getPromptOverwriteFile() {
        return this.m_FileChooser.getPromptOverwriteFile();
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_FileChooser.setAutoAppendExtension(value);
    }

    public boolean getAutoAppendExtension() {
        return this.m_FileChooser.getAutoAppendExtension();
    }

    public void setDefaultExtension(String value) {
        this.m_FileChooser.setDefaultExtension(value);
    }

    public String getDefaultExtension() {
        return this.m_FileChooser.getDefaultExtension();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(new PlaceholderFile(value));
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    @Override
    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(new PlaceholderFile(value));
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }

    public void setUseSaveDialog(boolean value) {
        this.m_UseSaveDialog = value;
    }

    public boolean getUseSaveDialog() {
        return this.m_UseSaveDialog;
    }
}

