/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.io.input.AbstractFlowReader;
import adams.data.io.input.DefaultFlowReader;
import adams.data.io.input.FlowReader;
import adams.data.io.output.AbstractFlowWriter;
import adams.data.io.output.DefaultFlowWriter;
import adams.data.io.output.FlowWriter;
import adams.gui.chooser.AbstractConfigurableExtensionFileFilterFileChooser;
import adams.gui.chooser.ExtensionFileFilterWithClass;
import adams.gui.chooser.FileTypeDeterminingFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlowFileChooser
extends AbstractConfigurableExtensionFileFilterFileChooser<FlowReader, FlowWriter>
implements FileTypeDeterminingFileChooser<FlowReader, FlowWriter> {
    private static final long serialVersionUID = -6341967475735162796L;
    protected static List<ExtensionFileFilterWithClass> m_ReaderFileFilters;
    protected static List<ExtensionFileFilterWithClass> m_WriterFileFilters;

    public FlowFileChooser() {
    }

    public FlowFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    public FlowFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters != null;
    }

    @Override
    protected void doInitializeFilters() {
        FlowFileChooser.initFilters(true, AbstractFlowReader.getReaders());
        FlowFileChooser.initFilters(false, AbstractFlowWriter.getWriters());
    }

    protected static void initFilters(boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        } else {
            m_WriterFileFilters = new ArrayList<ExtensionFileFilterWithClass>();
        }
        for (int i = 0; i < classnames.length; ++i) {
            ExtensionFileFilterWithClass filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((FlowReader)converter).getFormatDescription();
                    ext = ((FlowReader)converter).getFormatExtensions();
                } else {
                    desc = ((FlowWriter)converter).getFormatDescription();
                    ext = ((FlowWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to set up '" + classname + "':");
                e.printStackTrace();
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ExtensionFileFilterWithClass(classname, desc, ext);
                m_ReaderFileFilters.add(filter);
                continue;
            }
            filter = new ExtensionFileFilterWithClass(classname, desc, ext);
            m_WriterFileFilters.add(filter);
        }
        if (reader) {
            Collections.sort(m_ReaderFileFilters);
        } else {
            Collections.sort(m_WriterFileFilters);
        }
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getOpenFileFilters() {
        return m_ReaderFileFilters;
    }

    @Override
    protected List<ExtensionFileFilterWithClass> getSaveFileFilters() {
        return m_WriterFileFilters;
    }

    @Override
    protected Class getReaderClass() {
        return FlowReader.class;
    }

    @Override
    protected Class getWriterClass() {
        return FlowWriter.class;
    }

    @Override
    protected FlowReader getDefaultReader() {
        return new DefaultFlowReader();
    }

    @Override
    protected FlowWriter getDefaultWriter() {
        return new DefaultFlowWriter();
    }

    @Override
    public FlowReader getReaderForFile(File file) {
        FlowReader result = null;
        for (ExtensionFileFilterWithClass filter : m_ReaderFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (FlowReader)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate reader '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public FlowWriter getWriterForFile(File file) {
        FlowWriter result = null;
        for (ExtensionFileFilterWithClass filter : m_WriterFileFilters) {
            if (!filter.accept(file)) continue;
            try {
                result = (FlowWriter)Class.forName(filter.getClassname()).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate writer '" + filter.getClassname() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }
}

