/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.FileUtils;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BaseLogPanel
extends BasePanel {
    protected BaseTextArea m_TextLog;
    protected JButton m_ButtonClearLog;
    protected JButton m_ButtonCopyLog;
    protected JButton m_ButtonSaveLog;
    protected BaseFileChooser m_FileChooser;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TextLog = new BaseTextArea();
        this.m_TextLog.setLineWrap(false);
        this.m_TextLog.setEditable(false);
        this.m_TextLog.setFont(GUIHelper.getMonospacedFont());
        this.m_TextLog.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtons();
            }

            public void updateButtons() {
                boolean hasContent = BaseLogPanel.this.m_TextLog.getDocument().getLength() > 0;
                BaseLogPanel.this.m_ButtonClearLog.setEnabled(hasContent);
                BaseLogPanel.this.m_ButtonCopyLog.setEnabled(hasContent);
                BaseLogPanel.this.m_ButtonSaveLog.setEnabled(hasContent);
            }
        });
        this.add((Component)new BaseScrollPane(this.m_TextLog), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.add((Component)panel, "South");
        this.m_ButtonClearLog = new JButton(GUIHelper.getIcon("new.gif"));
        this.m_ButtonClearLog.setEnabled(false);
        this.m_ButtonClearLog.setToolTipText("Clear log");
        this.m_ButtonClearLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLogPanel.this.clear();
            }
        });
        panel.add(this.m_ButtonClearLog);
        this.m_ButtonCopyLog = new JButton(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopyLog.setEnabled(false);
        this.m_ButtonCopyLog.setToolTipText("Copy log");
        this.m_ButtonCopyLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLogPanel.this.copy();
            }
        });
        panel.add(this.m_ButtonCopyLog);
        this.m_ButtonSaveLog = new JButton(GUIHelper.getIcon("save.gif"));
        this.m_ButtonSaveLog.setEnabled(false);
        this.m_ButtonSaveLog.setToolTipText("Save log");
        this.m_ButtonSaveLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseLogPanel.this.save();
            }
        });
        panel.add(this.m_ButtonSaveLog);
    }

    public void setRows(int value) {
        this.m_TextLog.setRows(value);
    }

    public int getRows() {
        return this.m_TextLog.getRows();
    }

    public void setColumns(int value) {
        this.m_TextLog.setColumns(value);
    }

    public int getColumns() {
        return this.m_TextLog.getColumns();
    }

    public String getLog() {
        return this.m_TextLog.getText();
    }

    public void clear() {
        this.m_TextLog.setText("");
    }

    public void copy() {
        if (this.m_TextLog.getSelectedText() == null) {
            GUIHelper.copyToClipboard(this.m_TextLog.getText());
        } else {
            GUIHelper.copyToClipboard(this.m_TextLog.getSelectedText());
        }
    }

    public void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new BaseFileChooser();
            this.m_FileChooser.setAutoAppendExtension(true);
            ExtensionFileFilter filter = ExtensionFileFilter.getLogFileFilter();
            this.m_FileChooser.addChoosableFileFilter(filter);
            this.m_FileChooser.addChoosableFileFilter(ExtensionFileFilter.getTextFileFilter());
            this.m_FileChooser.setFileFilter(filter);
        }
        if ((retVal = this.m_FileChooser.showSaveDialog(this)) != 0) {
            return;
        }
        if (!FileUtils.writeToFile(this.m_FileChooser.getSelectedFile().getAbsolutePath(), (Object)this.getLog(), false)) {
            GUIHelper.showErrorMessage(this, "Failed to write log content to file:\n" + this.m_FileChooser.getSelectedFile());
        }
    }

    public void append(String msg) {
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        this.m_TextLog.append(msg);
    }
}

