/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.dotnotationtree;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.TransferableString;
import java.awt.datatransfer.Transferable;

public class DotNotationNode
extends BaseTreeNode {
    private static final long serialVersionUID = 9062259637831548370L;
    public static final String MULTIPLE_ROOT = "root";
    protected String m_Item = null;

    public DotNotationNode(String label) {
        super(label);
    }

    public String getLabel() {
        return (String)this.getUserObject();
    }

    public boolean isLabelMatch(String s) {
        return this.getLabel().equals(s);
    }

    public boolean isItemLeaf() {
        return this.isLeaf();
    }

    public String getSeparator() {
        return ".";
    }

    public String getItem() {
        String result = null;
        if (this.isItemLeaf()) {
            if (this.m_Item == null) {
                DotNotationNode node = this;
                this.m_Item = node.getLabel();
                while (node.getParent() != null) {
                    if ((node = (DotNotationNode)node.getParent()).isRoot() && node.getLabel().equals(MULTIPLE_ROOT)) continue;
                    this.m_Item = node.getLabel() + this.getSeparator() + this.m_Item;
                }
            }
            result = this.m_Item;
        }
        return result;
    }

    @Override
    public Transferable toTransferable() {
        return new TransferableString(this.getItem());
    }
}

