/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.ProcessCell;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;

public abstract class AbstractProcessCell
extends AbstractOptionHandler
implements ProcessCell {
    private static final long serialVersionUID = -1050881505327794503L;

    @Override
    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    @Override
    public String getIconName() {
        return null;
    }

    protected String check(SpreadSheetTable table, SpreadSheet sheet, int row, int column) {
        if (table == null) {
            return "No source table available!";
        }
        if (sheet == null) {
            return "No spreadsheet available!";
        }
        if (row < 0) {
            return "Negative row index!";
        }
        if (row >= sheet.getRowCount()) {
            return "Row index too large: " + (row + 1) + " > " + sheet.getRowCount();
        }
        if (column < 0) {
            return "Negative column index!";
        }
        if (column >= sheet.getColumnCount()) {
            return "Column index too large: " + (column + 1) + " > " + sheet.getColumnCount();
        }
        return null;
    }

    protected abstract boolean doProcessCell(SpreadSheetTable var1, SpreadSheet var2, int var3, int var4);

    @Override
    public boolean processCell(SpreadSheetTable table, SpreadSheet sheet, int row, int column) {
        boolean result;
        String error = this.check(table, sheet, row, column);
        boolean bl = result = error == null;
        if (result) {
            result = this.doProcessCell(table, sheet, row, column);
        } else {
            GUIHelper.showErrorMessage(table, "Failed to process cell " + SpreadSheet.getCellPosition(row, column) + "\n" + error);
        }
        return result;
    }
}

