/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.ArrayHistogram;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.PlotColumn;
import adams.gui.core.spreadsheettable.PlotRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;
import adams.gui.visualization.statistics.HistogramFactory;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Dialog;

public class Histogram
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -2452746814708360637L;

    @Override
    public String globalInfo() {
        return "Allows to plot either a row or a column from a spreadsheet";
    }

    @Override
    public String getMenuItem() {
        return "Histogram...";
    }

    @Override
    public String getIconName() {
        return "histogram.png";
    }

    @Override
    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    protected void plot(SpreadSheetTable table, SpreadSheet sheet, boolean isColumn, int index) {
        HistogramFactory.SetupDialog setup = GUIHelper.getParentDialog(table) != null ? HistogramFactory.getSetupDialog(GUIHelper.getParentDialog(table), Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog(GUIHelper.getParentFrame(table), true);
        setup.setDefaultCloseOperation(2);
        ArrayHistogram last = (ArrayHistogram)table.getLastSetup(this.getClass(), true, !isColumn);
        if (last == null) {
            last = new ArrayHistogram();
        }
        setup.setCurrent(last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent(table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        last = (ArrayHistogram)setup.getCurrent();
        table.addLastSetup(this.getClass(), true, !isColumn, last);
        TDoubleArrayList list = new TDoubleArrayList();
        if (isColumn) {
            for (int i = 0; i < sheet.getRowCount(); ++i) {
                if (!sheet.hasCell(i, index) || !sheet.getCell(i, index).isNumeric()) continue;
                list.add(sheet.getCell(i, index).toDouble().doubleValue());
            }
        } else {
            for (int i = 0; i < sheet.getColumnCount(); ++i) {
                if (!sheet.hasCell(index, i) || !sheet.getCell(index, i).isNumeric()) continue;
                list.add(sheet.getCell(index, i).toDouble().doubleValue());
            }
        }
        last.clear();
        HistogramFactory.Dialog dialog = GUIHelper.getParentDialog(table) != null ? HistogramFactory.getDialog(GUIHelper.getParentDialog(table), Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog(GUIHelper.getParentFrame(table), false);
        dialog.setDefaultCloseOperation(2);
        if (isColumn) {
            dialog.add(last, list.toArray(), "Column " + (index + 1) + "/" + sheet.getColumnName(index));
        } else {
            dialog.add(last, list.toArray(), "Row " + (index + 1));
        }
        dialog.setLocationRelativeTo(GUIHelper.getParentComponent(table));
        dialog.setVisible(true);
    }

    @Override
    public boolean plotColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        this.plot(table, sheet, true, column);
        return true;
    }

    @Override
    public boolean plotRow(SpreadSheetTable table, SpreadSheet sheet, int row) {
        this.plot(table, sheet, false, row);
        return true;
    }
}

