/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.AdditionalInformationHandler;
import adams.db.SQLStatement;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.RecentSQLStatementsHandler;
import adams.gui.core.SQLSyntaxEditorPanel;
import adams.gui.dialog.TextDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class SQLStatementPanel
extends BasePanel {
    private static final long serialVersionUID = -4419661519749458767L;
    public static final String SESSION_FILE = "SQLStatements.props";
    protected SQLSyntaxEditorPanel m_PanelStatement;
    protected JButton m_ButtonOptions;
    protected JButton m_ButtonHistory;
    protected JButton m_ButtonHelp;
    protected JPanel m_PanelBottom;
    protected JPanel m_PanelButtonsRight;
    protected JPanel m_PanelButtonsLeft;
    protected JPopupMenu m_PopupMenu;
    protected RecentSQLStatementsHandler<JPopupMenu> m_RecentStatementsHandler;

    @Override
    protected void initGUI() {
        this.m_PanelStatement = new SQLSyntaxEditorPanel();
        this.m_PanelStatement.setWordWrap(true);
        this.add((Component)this.m_PanelStatement, "Center");
        this.m_PanelBottom = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelBottom, "South");
        this.m_PanelButtonsLeft = new JPanel(new FlowLayout(0));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsLeft, "West");
        this.m_ButtonOptions = new JButton("...");
        this.m_ButtonOptions.setToolTipText("Options menu");
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Cut");
                menuitem.setIcon(GUIHelper.getIcon("cut.gif"));
                menuitem.setEnabled(SQLStatementPanel.this.m_PanelStatement.canCut());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLStatementPanel.this.m_PanelStatement.cut();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Copy");
                menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
                menuitem.setEnabled(SQLStatementPanel.this.m_PanelStatement.canCopy());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLStatementPanel.this.m_PanelStatement.copy();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Paste");
                menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
                menuitem.setEnabled(SQLStatementPanel.this.m_PanelStatement.canPaste());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLStatementPanel.this.m_PanelStatement.paste();
                    }
                });
                menu.add(menuitem);
                menuitem = new JCheckBoxMenuItem("Line wrap");
                menuitem.setIcon(GUIHelper.getEmptyIcon());
                menuitem.setSelected(SQLStatementPanel.this.m_PanelStatement.getWordWrap());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLStatementPanel.this.m_PanelStatement.setWordWrap(((JMenuItem)e.getSource()).isSelected());
                    }
                });
                menu.addSeparator();
                menu.add(menuitem);
                menu.show(SQLStatementPanel.this.m_ButtonOptions, 0, SQLStatementPanel.this.m_ButtonOptions.getHeight());
            }
        });
        this.m_PanelButtonsLeft.add(this.m_ButtonOptions);
        this.m_ButtonHistory = new JButton(GUIHelper.getIcon("history.png"));
        this.m_ButtonHistory.setToolTipText("Recent queries");
        this.m_ButtonHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLStatementPanel.this.m_PopupMenu.show(SQLStatementPanel.this.m_ButtonHistory, 0, SQLStatementPanel.this.m_ButtonHistory.getHeight());
            }
        });
        this.m_PanelButtonsLeft.add(this.m_ButtonHistory);
        this.m_PanelButtonsRight = new JPanel(new FlowLayout(2));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsRight, "East");
        if (this.m_PanelStatement instanceof AdditionalInformationHandler) {
            this.m_ButtonHelp = new JButton("Help");
            this.m_ButtonHelp.setMnemonic('H');
            this.m_ButtonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String help = ((AdditionalInformationHandler)((Object)SQLStatementPanel.this.m_PanelStatement)).getAdditionalInformation();
                    TextDialog dlg = new TextDialog();
                    dlg.setDefaultCloseOperation(2);
                    dlg.setDialogTitle("Help");
                    dlg.setContent(help);
                    dlg.setLineWrap(true);
                    dlg.setEditable(false);
                    dlg.setVisible(true);
                }
            });
            this.m_PanelButtonsRight.add(this.m_ButtonHelp);
        }
        this.m_PopupMenu = new JPopupMenu();
        this.m_RecentStatementsHandler = new RecentSQLStatementsHandler<JPopupMenu>(SESSION_FILE, 5, this.m_PopupMenu);
        this.m_RecentStatementsHandler.addRecentItemListener(new RecentItemListener<JPopupMenu, SQLStatement>(){

            @Override
            public void recentItemAdded(RecentItemEvent<JPopupMenu, SQLStatement> e) {
            }

            @Override
            public void recentItemSelected(RecentItemEvent<JPopupMenu, SQLStatement> e) {
                SQLStatementPanel.this.setStatement(e.getItem());
            }
        });
    }

    public void setStatement(SQLStatement value) {
        this.m_PanelStatement.setContent(value.getValue());
    }

    public SQLStatement getStatement() {
        return new SQLStatement(this.m_PanelStatement.getContent());
    }

    public void addStatementToHistory() {
        this.m_RecentStatementsHandler.addRecentItem(this.getStatement());
    }
}

