/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.io.PlaceholderFile;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetColumnComboBox;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.core.PopupMenuCustomizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpreadSheetPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 8089541494489119743L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected SpreadSheetFileChooser m_FileChooser;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileExit;
    protected JMenuItem m_MenuItemViewDisplayedDecimals;
    protected JMenuItem m_MenuItemViewNegativeBackground;
    protected JMenuItem m_MenuItemViewPositiveBackground;
    protected JMenuItem m_MenuItemViewShowFormulas;
    protected SearchPanel m_PanelSearch;
    protected SpreadSheetColumnComboBox m_ColumnComboBox;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel();
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        this.add((Component)new BaseScrollPane(this.m_Table), "Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        this.m_ColumnComboBox = new SpreadSheetColumnComboBox(this.m_Table);
        panel.add(this.m_ColumnComboBox);
        this.add((Component)panel, "North");
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.setVisible(false);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                SpreadSheetPanel.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    public void setSpreadSheet(SpreadSheet value) {
        this.m_TableModel = this.m_TableModel.newModel(value);
        this.m_Table.setModel(this.m_TableModel);
    }

    public SpreadSheet getSpreadSheet() {
        return this.m_TableModel.toSpreadSheet();
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Decimals...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed D"));
            menuitem.setIcon(GUIHelper.getIcon("decimal-place.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.enterNumDecimals();
                }
            });
            this.m_MenuItemViewDisplayedDecimals = menuitem;
            menuitem = new JMenuItem("Negative background...");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.selectBackground(true);
                }
            });
            this.m_MenuItemViewNegativeBackground = menuitem;
            menuitem = new JMenuItem("Positive background...");
            menu.add(menuitem);
            menuitem.setMnemonic('p');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.selectBackground(false);
                }
            });
            this.m_MenuItemViewPositiveBackground = menuitem;
            menuitem = new JCheckBoxMenuItem("Show formulas");
            menu.add(menuitem);
            menuitem.setMnemonic('f');
            menuitem.setIcon(GUIHelper.getIcon("formula.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetPanel.this.m_Table.setShowFormulas(SpreadSheetPanel.this.m_MenuItemViewShowFormulas.isSelected());
                }
            });
            this.m_MenuItemViewShowFormulas = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
    }

    protected void close() {
        this.closeParent();
    }

    protected void saveAs() {
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        this.write((SpreadSheetWriter)this.m_FileChooser.getWriter(), file);
    }

    public void write(SpreadSheetWriter writer, File file) {
        if (!writer.write(this.m_Table.toSpreadSheet(), file)) {
            GUIHelper.showErrorMessage(this, "Failed to write spreadsheet to '" + file + "'!");
        }
    }

    protected void enterNumDecimals() {
        int decimals = this.m_Table.getNumDecimals();
        String valueStr = GUIHelper.showInputDialog(this, "Please enter the number of decimals to display (-1 to display all):", "" + decimals);
        if (valueStr == null) {
            return;
        }
        decimals = Integer.parseInt(valueStr);
        this.m_Table.setNumDecimals(decimals);
    }

    protected void selectBackground(boolean negative) {
        Color color = negative ? this.m_Table.getNegativeBackground() : this.m_Table.getPositiveBackground();
        color = negative ? JColorChooser.showDialog(this, "Background for negative values", color) : JColorChooser.showDialog(this, "Background for positive values", color);
        if (color == null) {
            return;
        }
        if (negative) {
            this.m_Table.setNegativeBackground(color);
        } else {
            this.m_Table.setPositiveBackground(color);
        }
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JTable.class}, cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            SpreadSheet sheet = this.m_Table.toSpreadSheet();
            if (!writer.write(sheet, (File)((PlaceholderFile)(result = SendToActionUtils.nextTmpFile("spreadsheetpanel", "csv"))))) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, cls)) {
            result = this.m_Table;
        }
        return result;
    }

    public void setHeaderPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_Table.setHeaderPopupMenuCustomizer(value);
    }

    public PopupMenuCustomizer getHeadePopupMenuCustomizer() {
        return this.m_Table.getHeaderPopupMenuCustomizer();
    }

    public void setCellPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_Table.setCellPopupMenuCustomizer(value);
    }

    public PopupMenuCustomizer getCellPopupMenuCustomizer() {
        return this.m_Table.getCellPopupMenuCustomizer();
    }

    public boolean hasNegativeBackground() {
        return this.m_Table.hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        this.m_Table.setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return this.m_Table.getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return this.m_Table.hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        this.m_Table.setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return this.m_Table.getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        this.m_Table.setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return this.m_Table.getShowFormulas();
    }

    public void sort(RowComparator comparator) {
        this.m_Table.sort(comparator);
    }

    public void setNumDecimals(int value) {
        this.m_Table.setNumDecimals(value);
    }

    public int getNumDecimals() {
        return this.m_Table.getNumDecimals();
    }

    public void setShowSearch(boolean value) {
        this.m_PanelSearch.setVisible(value);
    }

    public boolean getShowSearch() {
        return this.m_PanelSearch.isVisible();
    }
}

