/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow;

import adams.core.CleanUpHandler;
import adams.core.Utils;
import adams.flow.control.Storage;
import adams.flow.control.StorageHandler;
import adams.flow.control.StorageName;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.goe.EditorHelper;
import adams.gui.visualization.debug.InspectionPanel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StoragePanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = 8244881694557542183L;
    protected StorageHandler m_Handler;
    protected SortableAndSearchableTableWithButtons m_Table;
    protected TableModel m_TableModel;
    protected JButton m_ButtonInspect;
    protected JButton m_ButtonEdit;
    protected JCheckBox m_CheckBoxPreview;
    protected BaseDialog m_DialogInspect;
    protected InspectionPanel m_PanelInspect;
    protected SearchPanel m_PanelSearch;
    protected JPanel m_PanelPreview;
    protected BaseSplitPane m_SplitPane;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setDividerLocation(150);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PanelPreview = new JPanel(new BorderLayout());
        this.m_SplitPane.setBottomComponent(this.m_PanelPreview);
        this.m_SplitPane.setBottomComponentHidden(false);
        JPanel panelTable = new JPanel(new BorderLayout());
        this.m_SplitPane.setTopComponent(panelTable);
        this.m_TableModel = new TableModel();
        this.m_Table = new SortableAndSearchableTableWithButtons(this.m_TableModel);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.setSelectionMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StoragePanel.this.updateButtons();
                StoragePanel.this.updatePreview();
            }
        });
        panelTable.add((Component)this.m_Table, "Center");
        this.m_ButtonInspect = new JButton("Inspect...");
        this.m_ButtonInspect.setMnemonic('I');
        this.m_ButtonInspect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoragePanel.this.inspect();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonInspect);
        this.m_Table.setDoubleClickButton(this.m_ButtonInspect);
        this.m_ButtonEdit = new JButton("Edit...");
        this.m_ButtonEdit.setMnemonic('E');
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoragePanel.this.edit();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonEdit);
        this.m_CheckBoxPreview = new JCheckBox("Preview");
        this.m_CheckBoxPreview.setSelected(true);
        this.m_CheckBoxPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoragePanel.this.m_SplitPane.setBottomComponentHidden(!StoragePanel.this.m_CheckBoxPreview.isSelected());
                StoragePanel.this.updatePreview();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_CheckBoxPreview);
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                ((SortableAndSearchableTable)StoragePanel.this.m_Table.getComponent()).search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        panelTable.add((Component)this.m_PanelSearch, "South");
        this.updateButtons();
    }

    protected void updateButtons() {
        int selCount = this.m_Table.getSelectedRowCount();
        Object selObj = this.getSelectedObject();
        this.m_ButtonInspect.setEnabled(selCount == 1);
        this.m_ButtonEdit.setEnabled(selCount == 1 && this.canEdit(selObj));
    }

    protected void updatePreview() {
        if (!this.m_PanelPreview.isVisible()) {
            return;
        }
        if (this.m_Table.getSelectedRowCount() != 1) {
            return;
        }
        Object obj = this.m_TableModel.getObject((String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 0), (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 1));
        this.m_PanelPreview.removeAll();
        AbstractObjectRenderer renderer = AbstractObjectRenderer.getRenderer(obj).get(0);
        renderer.render(obj, this.m_PanelPreview);
        this.m_PanelPreview.invalidate();
        this.m_PanelPreview.validate();
        this.m_PanelPreview.repaint();
    }

    protected String getSelectedObjectID() {
        if (this.m_Table.getSelectedRow() == -1) {
            return null;
        }
        String cache = (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 0);
        String name = (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 1);
        return "cache: " + (cache == null || cache.isEmpty() ? "-none-" : cache) + "/name: " + name;
    }

    protected Object getSelectedObject() {
        if (this.m_Table.getSelectedRow() == -1) {
            return null;
        }
        String cache = (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 0);
        String name = (String)this.m_Table.getValueAt(this.m_Table.getSelectedRow(), 1);
        return this.m_TableModel.getObject(cache, name);
    }

    protected void inspect() {
        if (this.m_DialogInspect == null) {
            this.m_PanelInspect = new InspectionPanel();
            this.m_DialogInspect = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            this.m_DialogInspect.getContentPane().setLayout(new BorderLayout());
            this.m_DialogInspect.getContentPane().add((Component)this.m_PanelInspect, "Center");
            this.m_DialogInspect.setLocationRelativeTo(this);
        }
        this.m_DialogInspect.setTitle("Inspect (" + this.getSelectedObjectID() + ")");
        this.m_PanelInspect.setCurrent(this.getSelectedObject());
        this.m_DialogInspect.setSize(800, 600);
        this.m_DialogInspect.setVisible(true);
    }

    protected boolean canEdit(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isArray()) {
            return true;
        }
        return PropertyEditorManager.findEditor(obj.getClass()) != null;
    }

    protected void edit() {
        Object newObj = EditorHelper.simpleEdit(this, this.getSelectedObject(), this.getSelectedObjectID());
        if (newObj != null) {
            this.m_Table.setValueAt(newObj, this.m_Table.getSelectedRow(), 2);
            this.updatePreview();
        }
    }

    public void setHandler(StorageHandler value) {
        this.m_Handler = value;
        this.m_TableModel = new TableModel(value.getStorage());
        this.m_Table.setModel(this.m_TableModel);
        this.m_Table.setOptimalColumnWidth();
        this.updateButtons();
    }

    public StorageHandler getHandler() {
        return this.m_Handler;
    }

    @Override
    public void cleanUp() {
        if (this.m_PanelInspect != null) {
            this.m_PanelInspect.closeParent();
            this.m_PanelInspect = null;
        }
    }

    public static class TableModel
    extends AbstractBaseTableModel {
        private static final long serialVersionUID = 3509104625095997777L;
        protected Storage m_Storage;
        protected String[][] m_Data;

        public TableModel() {
            this(new Storage());
        }

        public TableModel(Storage storage) {
            this.m_Storage = storage;
            this.initialize();
        }

        protected String getClassString(Object obj) {
            Class<?> cls = obj.getClass();
            String result = cls.isArray() ? Utils.classToString(cls) + " (length: " + Array.getLength(obj) + ")" : (obj instanceof Collection ? cls.getName() + " (size: " + ((Collection)obj).size() + ")" : cls.getName());
            return result;
        }

        protected void initialize() {
            String cache;
            int size = this.m_Storage.size();
            Iterator<String> caches = this.m_Storage.caches();
            while (caches.hasNext()) {
                cache = caches.next();
                size += this.m_Storage.size(cache);
            }
            this.m_Data = new String[size][3];
            int index = 0;
            AbstractList keys = new ArrayList<StorageName>(this.m_Storage.keySet());
            Collections.sort(keys);
            for (StorageName key : keys) {
                this.m_Data[index][0] = "";
                this.m_Data[index][1] = key.getValue();
                this.m_Data[index][2] = this.getClassString(this.m_Storage.get(key));
                ++index;
            }
            caches = this.m_Storage.caches();
            while (caches.hasNext()) {
                cache = caches.next();
                keys = new Vector<StorageName>(this.m_Storage.keySet(cache));
                Collections.sort(keys);
                for (StorageName key : keys) {
                    this.m_Data[index][0] = cache;
                    this.m_Data[index][1] = key.getValue();
                    this.m_Data[index][2] = this.getClassString(this.m_Storage.get(cache, key));
                    ++index;
                }
            }
        }

        public Object getObject(String cache, String key) {
            if (cache == null || cache.length() == 0) {
                return this.m_Storage.get(new StorageName(key));
            }
            return this.m_Storage.get(cache, new StorageName(key));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.m_Data.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.m_Data[rowIndex][columnIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                String cache = (String)this.getValueAt(rowIndex, 0);
                String name = (String)this.getValueAt(rowIndex, 1);
                if (cache == null || cache.isEmpty()) {
                    this.m_Storage.put(new StorageName(name), aValue);
                } else {
                    this.m_Storage.put(cache, new StorageName(name), aValue);
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Cache";
            }
            if (column == 1) {
                return "Name";
            }
            if (column == 2) {
                return "Type";
            }
            throw new IllegalArgumentException("Illegal column index: " + column);
        }
    }
}

