/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.menu;

import adams.core.Utils;
import adams.core.option.NestedConsumer;
import adams.flow.core.AbstractActor;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.menu.AbstractFlowEditorMenuItemAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Socket;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class FileOpenRemoteFlow
extends AbstractFlowEditorMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;

    @Override
    protected String getTitle() {
        return "Open remote flow...";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openRemote(String server, int port) {
        StringBuilder buffer = new StringBuilder();
        Socket socket = null;
        try {
            String line;
            socket = new Socket(server, port);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = in.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            in.close();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(((FlowEditorPanel)this.m_State).getParentDialog(), "Failed to connect to " + server + ":" + port + "\n" + Utils.throwableToString(e));
            return;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        NestedConsumer consumer = new NestedConsumer();
        AbstractActor actor = (AbstractActor)consumer.fromString(buffer.toString());
        if (actor == null) {
            GUIHelper.showErrorMessage(((FlowEditorPanel)this.m_State).getParentDialog(), "Failed to instantiate flow from:\n" + buffer);
        } else {
            FlowPanel panel = ((FlowEditorPanel)this.m_State).getFlowPanels().newPanel();
            panel.setCurrentFlow(actor);
            panel.setTitle(server + ":" + port);
            panel.updateTitle();
        }
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        ParameterPanel panel = new ParameterPanel();
        JTextField textServer = new JTextField(20);
        textServer.setText("127.0.0.1");
        panel.addParameter("Server", textServer);
        JSpinner spinnerPort = new JSpinner();
        ((SpinnerNumberModel)spinnerPort.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)spinnerPort.getModel()).setMaximum(Integer.valueOf(65535));
        spinnerPort.setValue(12345);
        panel.addParameter("Port", spinnerPort);
        ApprovalDialog dialog = new ApprovalDialog(((FlowEditorPanel)this.m_State).getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Open remote flow");
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(((FlowEditorPanel)this.m_State).getParentDialog());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        this.openRemote(textServer.getText(), (Integer)spinnerPort.getValue());
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(true);
    }
}

