/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.flow.core.AbstractDisplay;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tab.AbstractTabChangeAwareEditorTab;
import adams.gui.flow.tab.RuntimeTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;

public class RegisteredDisplaysTab
extends AbstractTabChangeAwareEditorTab
implements RuntimeTab {
    private static final long serialVersionUID = 3636125950515045125L;

    @Override
    public String getTitle() {
        return "Displays";
    }

    public void update() {
        this.flowPanelChanged(this.getCurrentPanel());
    }

    @Override
    public synchronized void flowPanelChanged(FlowPanel panel) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
            this.getParent().repaint();
        }
        if (panel == null) {
            return;
        }
        HashMap<Class, HashMap<String, AbstractDisplay>> registered = panel.getRegisteredDisplays();
        if (registered.size() == 0) {
            return;
        }
        BaseTabbedPane tabbedCls = new BaseTabbedPane(3);
        this.add((Component)tabbedCls, "Center");
        for (Class regCls : registered.keySet()) {
            HashMap<String, AbstractDisplay> displays = registered.get(regCls);
            if (displays.size() == 0) continue;
            BaseTabbedPane tabbedDisplays = new BaseTabbedPane(1);
            for (String name : displays.keySet()) {
                AbstractDisplay display = displays.get(name);
                String title = name;
                if (display.getParentComponent() instanceof FlowPanel) {
                    title = ((FlowPanel)display.getParentComponent()).getTitle() + ":" + title;
                }
                tabbedDisplays.addTab(title, display.getPanel());
            }
            BasePanel bpanel = new BasePanel(new BorderLayout());
            bpanel.add((Component)tabbedDisplays, "Center");
            tabbedCls.addTab("Type:" + regCls.getSimpleName(), bpanel);
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
            this.getParent().repaint();
        }
    }
}

