/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.CallableSink;
import adams.flow.source.CallableSource;
import adams.flow.standalone.CallableActors;
import adams.flow.standalone.GridView;
import adams.flow.standalone.TabView;
import adams.flow.transformer.CallableTransformer;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import adams.gui.goe.FlowHelper;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.tree.TreePath;

public class CreateCallableActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Create callable actor";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).isSingleSel && ((StateContainer)this.m_State).tree.getOwner() != null);
    }

    protected void createCallableActor(TreePath path) {
        Node callableNode;
        Node currNode = TreeHelper.pathToNode(path);
        AbstractActor currActor = currNode.getFullActor().shallowCopy();
        if (ActorUtils.isStandalone(currActor)) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Standalone actors cannot be turned into a callable actor!");
            return;
        }
        if (currActor instanceof AbstractCallableActor) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Actor points already to a callable actor!");
            return;
        }
        if (currNode.getParent() != null && ((Node)currNode.getParent()).getActor() instanceof CallableActors) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Actor is already a callable actor!");
            return;
        }
        this.addUndoPoint("Creating callable actor from '" + currNode.getActor().getFullName());
        List<Node> callable = FlowHelper.findCallableActorsHandler(currNode, (Node)currNode.getParent(), new Class[]{CallableActors.class});
        List<Node> multiview = FlowHelper.findCallableActorsHandler(currNode, (Node)currNode.getParent(), new Class[]{GridView.class, TabView.class});
        if (callable.size() == 0) {
            Node root = (Node)currNode.getRoot();
            if (!((ActorHandler)((Object)root.getActor())).getActorHandlerInfo().canContainStandalones()) {
                GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Root actor '" + root.getActor().getName() + "' cannot contain standalones!");
                return;
            }
            CallableActors callableActors = new CallableActors();
            callableNode = new Node(((StateContainer)this.m_State).tree, callableActors);
            int index = 0;
            if (multiview.size() > 0) {
                for (Node node : multiview) {
                    if (node.getParent().getIndex(node) < index) continue;
                    index = node.getParent().getIndex(node) + 1;
                }
            }
            root.insert(callableNode, index);
            ((StateContainer)this.m_State).tree.updateActorName(callableNode);
        } else {
            callableNode = callable.get(callable.size() - 1);
        }
        List<TreePath> exp = ((StateContainer)this.m_State).tree.getExpandedNodes();
        Node moved = ((StateContainer)this.m_State).tree.buildTree(callableNode, currActor, true);
        ((StateContainer)this.m_State).tree.updateActorName(moved);
        AbstractCallableActor replacement = null;
        if (ActorUtils.isSource(currActor)) {
            replacement = new CallableSource();
        } else if (ActorUtils.isTransformer(currActor)) {
            replacement = new CallableTransformer();
        } else if (ActorUtils.isSink(currActor)) {
            replacement = new CallableSink();
        }
        replacement.setCallableName(new CallableActorReference(moved.getActor().getName()));
        currNode.setActor(replacement);
        currNode.removeAllChildren();
        ((StateContainer)this.m_State).tree.updateActorName(currNode);
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.nodeStructureChanged(callableNode);
        ((StateContainer)this.m_State).tree.setExpandedNodes(exp);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, callableNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.nodeStructureChanged((Node)currNode.getParent());
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, currNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.expand(callableNode);
        ((StateContainer)this.m_State).tree.locateAndDisplay(currNode.getFullName());
        ((StateContainer)this.m_State).tree.redraw();
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.createCallableActor(((StateContainer)this.m_State).selPath);
    }
}

