/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractDisplay;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHandler;
import adams.flow.core.MutableActorHandler;
import adams.flow.sink.DisplayPanelManager;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BaseMenu;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuItemComparator;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class EncloseActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Enclose";
    }

    protected void encloseActor(TreePath[] paths, ActorHandler handler) {
        Node currNode;
        int i;
        Node parent = null;
        AbstractActor[] currActor = new AbstractActor[paths.length];
        for (i = 0; i < paths.length; ++i) {
            currNode = TreeHelper.pathToNode(paths[i]);
            currActor[i] = currNode.getFullActor().shallowCopy();
            if (parent == null) {
                parent = (Node)currNode.getParent();
            }
            if (!ActorUtils.isStandalone(currActor[i]) || handler.getActorHandlerInfo().canContainStandalones()) continue;
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "You cannot enclose a standalone actor in a " + handler.getClass().getSimpleName() + "!");
            return;
        }
        String newName = handler.getName();
        if (parent.getActor() instanceof CallableActorHandler && currActor.length == 1) {
            newName = currActor[0].getName();
        }
        if ((newName = GUIHelper.showInputDialog(GUIHelper.getParentComponent(((StateContainer)this.m_State).tree), "Please enter name for enclosing actor (leave empty for default):", newName)) == null) {
            return;
        }
        if (newName.isEmpty()) {
            newName = handler.getDefaultName();
        }
        handler.setName(newName);
        if (paths.length == 1) {
            this.addUndoPoint("Enclosing node '" + TreeHelper.pathToActor(paths[0]).getFullName() + "' in " + handler.getClass().getName());
        } else {
            this.addUndoPoint("Enclosing " + paths.length + " nodes in " + handler.getClass().getName());
        }
        try {
            if (handler instanceof MutableActorHandler) {
                MutableActorHandler mutable = (MutableActorHandler)handler;
                mutable.removeAll();
                for (i = 0; i < currActor.length; ++i) {
                    mutable.add(i, currActor[i]);
                }
            } else {
                handler.set(0, currActor[0]);
            }
            Node newNode = ((StateContainer)this.m_State).tree.buildTree(null, (AbstractActor)((Object)handler), false);
            for (i = 0; i < paths.length; ++i) {
                currNode = TreeHelper.pathToNode(paths[i]);
                int index = parent.getIndex(currNode);
                parent.remove(index);
                if (i != 0) continue;
                parent.insert(newNode, index);
            }
            ((StateContainer)this.m_State).tree.updateActorName(newNode);
            ((StateContainer)this.m_State).tree.setModified(true);
            if (paths.length == 1) {
                ((StateContainer)this.m_State).tree.nodeStructureChanged(newNode);
                ((StateContainer)this.m_State).tree.expand(newNode);
                ((StateContainer)this.m_State).tree.locateAndDisplay(newNode.getFullName());
                ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, newNode, ActorChangeEvent.Type.MODIFY));
            } else {
                ((StateContainer)this.m_State).tree.nodeStructureChanged(parent);
                ((StateContainer)this.m_State).tree.expand(parent);
                ((StateContainer)this.m_State).tree.locateAndDisplay(parent.getFullName());
                ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, parent, ActorChangeEvent.Type.MODIFY));
            }
            ((StateContainer)this.m_State).tree.redraw();
        }
        catch (Exception e) {
            String msg = paths.length == 1 ? "Failed to enclose actor '" + TreeHelper.pathToActor(paths[0]).getFullName() + "'" : "Failed to enclose " + paths.length + " actors";
            msg = msg + " in a " + handler.getClass().getSimpleName() + ": ";
            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, msg + "\n" + Utils.throwableToString(e));
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, msg + "\n" + e.getMessage());
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        JMenuItem menuitem;
        ArrayList<JMenuItem> menuitems = new ArrayList<JMenuItem>();
        String[] actors = ClassLister.getSingleton().getClassnames(ActorHandler.class);
        for (int i = 0; i < actors.length; ++i) {
            final ActorHandler actor = (ActorHandler)((Object)AbstractActor.forName(actors[i], new String[0]));
            if (!actor.getActorHandlerInfo().canEncloseActors() || actor instanceof Flow || ((StateContainer)this.m_State).selPaths != null && ((StateContainer)this.m_State).selPaths.length > 1 && !(actor instanceof MutableActorHandler)) continue;
            menuitem = new JMenuItem(actor.getClass().getSimpleName());
            menuitems.add(menuitem);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EncloseActor.this.encloseActor(((StateContainer)((EncloseActor)EncloseActor.this).m_State).selPaths, actor);
                }
            });
        }
        Collections.sort(menuitems, new MenuItemComparator());
        BaseMenu result = BaseMenu.createCascadingMenu(menuitems, -1, "More...");
        result.setText(this.getName());
        result.setEnabled(this.isEnabled());
        result.setIcon(this.getIcon());
        if (((StateContainer)this.m_State).isSingleSel && ((StateContainer)this.m_State).selNode.getActor() instanceof DisplayPanelProvider) {
            result.addSeparator();
            menuitem = new JMenuItem(DisplayPanelManager.class.getSimpleName());
            result.add(menuitem);
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EncloseActor.this.encloseInDisplayPanelManager(((StateContainer)((EncloseActor)EncloseActor.this).m_State).selPaths[0]);
                }
            });
        }
        return result;
    }

    protected void encloseInDisplayPanelManager(TreePath path) {
        Node currNode = TreeHelper.pathToNode(path);
        AbstractActor currActor = currNode.getFullActor().shallowCopy();
        DisplayPanelManager manager = new DisplayPanelManager();
        manager.setName(currActor.getName());
        manager.setPanelProvider((DisplayPanelProvider)((Object)currActor));
        if (currActor instanceof AbstractDisplay) {
            AbstractDisplay display = (AbstractDisplay)currActor;
            manager.setWidth(display.getWidth() + 100);
            manager.setHeight(display.getHeight());
            manager.setX(display.getX());
            manager.setY(display.getY());
        }
        this.addUndoPoint("Enclosing node '" + currNode.getActor().getFullName() + "' in " + manager.getClass().getName());
        List<TreePath> exp = ((StateContainer)this.m_State).tree.getExpandedNodes();
        currNode.setActor(manager);
        ((StateContainer)this.m_State).tree.setModified(true);
        ((StateContainer)this.m_State).tree.nodeStructureChanged((Node)currNode.getParent());
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, currNode, ActorChangeEvent.Type.MODIFY));
        ((StateContainer)this.m_State).tree.setExpandedNodes(exp);
        ((StateContainer)this.m_State).tree.expand(currNode);
        ((StateContainer)this.m_State).tree.locateAndDisplay(currNode.getFullName());
        ((StateContainer)this.m_State).tree.redraw();
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).parent != null && ((StateContainer)this.m_State).numSel > 0);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
    }
}

