/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.gui.core.NumberTextField;
import adams.gui.goe.AbstractFloatingPointNumberEditor;

public class DoubleEditor
extends AbstractFloatingPointNumberEditor {
    public DoubleEditor() {
        this.m_CurrentValue = new Double(0.0);
    }

    @Override
    protected NumberTextField.Type getType() {
        return NumberTextField.Type.DOUBLE;
    }

    @Override
    public void setValue(Object value) {
        this.m_CurrentValue = new Double(((Number)value).doubleValue());
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_CurrentValue;
    }

    @Override
    protected String toString(Object obj) {
        return Utils.doubleToString((Double)obj, 8);
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        Double result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = Utils.toDouble(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }
}

