/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.Index;
import adams.core.Utils;
import adams.core.VariableName;
import adams.core.base.BaseAnnotation;
import adams.core.base.BaseText;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.DecimalFormatString;
import adams.data.conversion.DoubleToString;
import adams.data.io.output.NullWriter;
import adams.data.random.JavaRandomDouble;
import adams.data.random.JavaRandomInt;
import adams.flow.condition.bool.Expression;
import adams.flow.control.ArrayProcess;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.control.IfThenElse;
import adams.flow.control.Sequence;
import adams.flow.control.Tee;
import adams.flow.control.TimedTee;
import adams.flow.control.TimedTrigger;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.execution.NullListener;
import adams.flow.sink.CallableSink;
import adams.flow.sink.Display;
import adams.flow.sink.DumpFile;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.NoErrorPaintlet;
import adams.flow.sink.sequenceplotter.NoMarkers;
import adams.flow.sink.sequenceplotter.NullClickAction;
import adams.flow.sink.sequenceplotter.PassThrough;
import adams.flow.sink.sequenceplotter.SimplePlotUpdater;
import adams.flow.source.CombineVariables;
import adams.flow.source.EnterManyValues;
import adams.flow.source.ForLoop;
import adams.flow.source.RandomNumberGenerator;
import adams.flow.source.Start;
import adams.flow.source.ValueDefinition;
import adams.flow.source.Variable;
import adams.flow.standalone.CallableActors;
import adams.flow.standalone.GridView;
import adams.flow.standalone.Standalones;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.Convert;
import adams.flow.transformer.DeleteFile;
import adams.flow.transformer.GetArrayElement;
import adams.flow.transformer.MakePlotContainer;
import adams.flow.transformer.MathExpression;
import adams.flow.transformer.SequenceToArray;
import adams.flow.transformer.SetVariable;
import adams.flow.transformer.StringJoin;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.LOWESSOverlayPaintlet;
import adams.parser.BooleanExpressionText;
import adams.parser.MathematicalExpressionText;
import java.awt.Color;

public class SystemPerformance
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = 7586443345167287461L;

    public SystemPerformance() {
        this(null);
    }

    public SystemPerformance(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    public String getIconName() {
        return "performance.png";
    }

    @Override
    public String getTitle() {
        return "System performance";
    }

    @Override
    protected boolean getUseThread() {
        return true;
    }

    @Override
    public void launch() {
        try {
            Flow flow = (Flow)this.getActor();
            flow.setDefaultCloseOperation(2);
            String msg = flow.setUp();
            if (msg == null) {
                msg = flow.execute();
            }
            flow.wrapUp();
            if (msg != null) {
                GUIHelper.showErrorMessage(this.getOwner(), "Failed to test system performance:\n" + msg);
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(this.getOwner(), "Failed to test system performance:\n" + Utils.throwableToString(e));
        }
    }

    @Override
    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public String getCategory() {
        return "Help";
    }

    public AbstractActor getActor() throws Exception {
        Flow actor = new Flow();
        actor.setErrorHandling(Flow.ErrorHandling.ACTORS_DECIDE_TO_STOP_ON_ERROR);
        AbstractArgumentOption argOption = (AbstractArgumentOption)actor.getOptionManager().findByProperty("annotations");
        actor.setAnnotations((BaseAnnotation)argOption.valueOf("Uses flow components to give an overview of the system's performance."));
        argOption = (AbstractArgumentOption)actor.getOptionManager().findByProperty("actors");
        AbstractActor[] actors2 = new AbstractActor[8];
        GridView gridview3 = new GridView();
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("name");
        gridview3.setName((String)argOption.valueOf("System performance"));
        gridview3.setShortTitle(true);
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("x");
        gridview3.setX((Integer)argOption.valueOf("-2"));
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("y");
        gridview3.setY((Integer)argOption.valueOf("-2"));
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("actors");
        AbstractActor[] actors7 = new AbstractActor[3];
        SequencePlotter sequenceplotter8 = new SequencePlotter();
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("name");
        sequenceplotter8.setName((String)argOption.valueOf("CPU"));
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("writer");
        adams.gui.print.NullWriter nullwriter11 = new adams.gui.print.NullWriter();
        sequenceplotter8.setWriter(nullwriter11);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("paintlet");
        CirclePaintlet circlepaintlet13 = new CirclePaintlet();
        sequenceplotter8.setPaintlet(circlepaintlet13);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("overlayPaintlet");
        LOWESSOverlayPaintlet lowessoverlaypaintlet15 = new LOWESSOverlayPaintlet();
        argOption = (AbstractArgumentOption)lowessoverlaypaintlet15.getOptionManager().findByProperty("color");
        lowessoverlaypaintlet15.setColor((Color)argOption.valueOf("#ff0000"));
        argOption = (AbstractArgumentOption)lowessoverlaypaintlet15.getOptionManager().findByProperty("window");
        lowessoverlaypaintlet15.setWindow((Integer)argOption.valueOf("50"));
        sequenceplotter8.setOverlayPaintlet(lowessoverlaypaintlet15);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("markerPaintlet");
        NoMarkers nomarkers19 = new NoMarkers();
        sequenceplotter8.setMarkerPaintlet(nomarkers19);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("errorPaintlet");
        NoErrorPaintlet noerrorpaintlet21 = new NoErrorPaintlet();
        sequenceplotter8.setErrorPaintlet(noerrorpaintlet21);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("mouseClickAction");
        NullClickAction nullclickaction23 = new NullClickAction();
        sequenceplotter8.setMouseClickAction(nullclickaction23);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("colorProvider");
        DefaultColorProvider defaultcolorprovider25 = new DefaultColorProvider();
        sequenceplotter8.setColorProvider(defaultcolorprovider25);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("overlayColorProvider");
        DefaultColorProvider defaultcolorprovider27 = new DefaultColorProvider();
        sequenceplotter8.setOverlayColorProvider(defaultcolorprovider27);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("title");
        sequenceplotter8.setTitle((String)argOption.valueOf("CPU"));
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("axisX");
        AxisPanelOptions axispaneloptions30 = new AxisPanelOptions();
        argOption = (AbstractArgumentOption)axispaneloptions30.getOptionManager().findByProperty("label");
        axispaneloptions30.setLabel((String)argOption.valueOf("evaluations"));
        argOption = (AbstractArgumentOption)axispaneloptions30.getOptionManager().findByProperty("tickGenerator");
        FancyTickGenerator fancytickgenerator33 = new FancyTickGenerator();
        axispaneloptions30.setTickGenerator(fancytickgenerator33);
        argOption = (AbstractArgumentOption)axispaneloptions30.getOptionManager().findByProperty("nthValueToShow");
        axispaneloptions30.setNthValueToShow((Integer)argOption.valueOf("2"));
        argOption = (AbstractArgumentOption)axispaneloptions30.getOptionManager().findByProperty("width");
        axispaneloptions30.setWidth((Integer)argOption.valueOf("40"));
        argOption = (AbstractArgumentOption)axispaneloptions30.getOptionManager().findByProperty("customFormat");
        axispaneloptions30.setCustomFormat((DecimalFormatString)argOption.valueOf("0"));
        sequenceplotter8.setAxisX(axispaneloptions30);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("axisY");
        AxisPanelOptions axispaneloptions38 = new AxisPanelOptions();
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("label");
        axispaneloptions38.setLabel((String)argOption.valueOf("msec"));
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("tickGenerator");
        FancyTickGenerator fancytickgenerator41 = new FancyTickGenerator();
        axispaneloptions38.setTickGenerator(fancytickgenerator41);
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("nthValueToShow");
        axispaneloptions38.setNthValueToShow((Integer)argOption.valueOf("2"));
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("width");
        axispaneloptions38.setWidth((Integer)argOption.valueOf("60"));
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("topMargin");
        axispaneloptions38.setTopMargin((Double)argOption.valueOf("0.05"));
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("bottomMargin");
        axispaneloptions38.setBottomMargin((Double)argOption.valueOf("0.05"));
        argOption = (AbstractArgumentOption)axispaneloptions38.getOptionManager().findByProperty("customFormat");
        axispaneloptions38.setCustomFormat((DecimalFormatString)argOption.valueOf("0"));
        sequenceplotter8.setAxisY(axispaneloptions38);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("plotUpdater");
        SimplePlotUpdater simpleplotupdater48 = new SimplePlotUpdater();
        argOption = (AbstractArgumentOption)simpleplotupdater48.getOptionManager().findByProperty("updateInterval");
        argOption.setVariable("@{cpu_plot_update}");
        sequenceplotter8.setPlotUpdater(simpleplotupdater48);
        argOption = (AbstractArgumentOption)sequenceplotter8.getOptionManager().findByProperty("postProcessor");
        PassThrough passthrough50 = new PassThrough();
        sequenceplotter8.setPostProcessor(passthrough50);
        actors7[0] = sequenceplotter8;
        SequencePlotter sequenceplotter51 = new SequencePlotter();
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("name");
        sequenceplotter51.setName((String)argOption.valueOf("Write"));
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("writer");
        adams.gui.print.NullWriter nullwriter54 = new adams.gui.print.NullWriter();
        sequenceplotter51.setWriter(nullwriter54);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("paintlet");
        CirclePaintlet circlepaintlet56 = new CirclePaintlet();
        sequenceplotter51.setPaintlet(circlepaintlet56);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("overlayPaintlet");
        LOWESSOverlayPaintlet lowessoverlaypaintlet58 = new LOWESSOverlayPaintlet();
        argOption = (AbstractArgumentOption)lowessoverlaypaintlet58.getOptionManager().findByProperty("color");
        lowessoverlaypaintlet58.setColor((Color)argOption.valueOf("#ff0000"));
        argOption = (AbstractArgumentOption)lowessoverlaypaintlet58.getOptionManager().findByProperty("window");
        lowessoverlaypaintlet58.setWindow((Integer)argOption.valueOf("50"));
        sequenceplotter51.setOverlayPaintlet(lowessoverlaypaintlet58);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("markerPaintlet");
        NoMarkers nomarkers62 = new NoMarkers();
        sequenceplotter51.setMarkerPaintlet(nomarkers62);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("errorPaintlet");
        NoErrorPaintlet noerrorpaintlet64 = new NoErrorPaintlet();
        sequenceplotter51.setErrorPaintlet(noerrorpaintlet64);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("mouseClickAction");
        NullClickAction nullclickaction66 = new NullClickAction();
        sequenceplotter51.setMouseClickAction(nullclickaction66);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("colorProvider");
        DefaultColorProvider defaultcolorprovider68 = new DefaultColorProvider();
        sequenceplotter51.setColorProvider(defaultcolorprovider68);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("overlayColorProvider");
        DefaultColorProvider defaultcolorprovider70 = new DefaultColorProvider();
        sequenceplotter51.setOverlayColorProvider(defaultcolorprovider70);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("title");
        sequenceplotter51.setTitle((String)argOption.valueOf("Write"));
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("axisX");
        AxisPanelOptions axispaneloptions73 = new AxisPanelOptions();
        argOption = (AbstractArgumentOption)axispaneloptions73.getOptionManager().findByProperty("label");
        axispaneloptions73.setLabel((String)argOption.valueOf("evaluations"));
        argOption = (AbstractArgumentOption)axispaneloptions73.getOptionManager().findByProperty("tickGenerator");
        FancyTickGenerator fancytickgenerator76 = new FancyTickGenerator();
        axispaneloptions73.setTickGenerator(fancytickgenerator76);
        argOption = (AbstractArgumentOption)axispaneloptions73.getOptionManager().findByProperty("nthValueToShow");
        axispaneloptions73.setNthValueToShow((Integer)argOption.valueOf("2"));
        argOption = (AbstractArgumentOption)axispaneloptions73.getOptionManager().findByProperty("width");
        axispaneloptions73.setWidth((Integer)argOption.valueOf("40"));
        argOption = (AbstractArgumentOption)axispaneloptions73.getOptionManager().findByProperty("customFormat");
        axispaneloptions73.setCustomFormat((DecimalFormatString)argOption.valueOf("0"));
        sequenceplotter51.setAxisX(axispaneloptions73);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("axisY");
        AxisPanelOptions axispaneloptions81 = new AxisPanelOptions();
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("label");
        axispaneloptions81.setLabel((String)argOption.valueOf("msec"));
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("tickGenerator");
        FancyTickGenerator fancytickgenerator84 = new FancyTickGenerator();
        axispaneloptions81.setTickGenerator(fancytickgenerator84);
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("nthValueToShow");
        axispaneloptions81.setNthValueToShow((Integer)argOption.valueOf("2"));
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("width");
        axispaneloptions81.setWidth((Integer)argOption.valueOf("60"));
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("topMargin");
        axispaneloptions81.setTopMargin((Double)argOption.valueOf("0.05"));
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("bottomMargin");
        axispaneloptions81.setBottomMargin((Double)argOption.valueOf("0.05"));
        argOption = (AbstractArgumentOption)axispaneloptions81.getOptionManager().findByProperty("customFormat");
        axispaneloptions81.setCustomFormat((DecimalFormatString)argOption.valueOf("0"));
        sequenceplotter51.setAxisY(axispaneloptions81);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("plotUpdater");
        SimplePlotUpdater simpleplotupdater91 = new SimplePlotUpdater();
        argOption = (AbstractArgumentOption)simpleplotupdater91.getOptionManager().findByProperty("updateInterval");
        argOption.setVariable("@{write_plot_update}");
        sequenceplotter51.setPlotUpdater(simpleplotupdater91);
        argOption = (AbstractArgumentOption)sequenceplotter51.getOptionManager().findByProperty("postProcessor");
        PassThrough passthrough93 = new PassThrough();
        sequenceplotter51.setPostProcessor(passthrough93);
        actors7[1] = sequenceplotter51;
        Display display94 = new Display();
        argOption = (AbstractArgumentOption)display94.getOptionManager().findByProperty("name");
        display94.setName((String)argOption.valueOf("Overall"));
        argOption = (AbstractArgumentOption)display94.getOptionManager().findByProperty("writer");
        NullWriter nullwriter97 = new NullWriter();
        display94.setWriter(nullwriter97);
        actors7[2] = display94;
        gridview3.setActors(actors7);
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("numRows");
        gridview3.setNumRows((Integer)argOption.valueOf("3"));
        argOption = (AbstractArgumentOption)gridview3.getOptionManager().findByProperty("writer");
        adams.gui.print.NullWriter nullwriter100 = new adams.gui.print.NullWriter();
        gridview3.setWriter(nullwriter100);
        actors2[0] = gridview3;
        CallableActors callableactors101 = new CallableActors();
        argOption = (AbstractArgumentOption)callableactors101.getOptionManager().findByProperty("actors");
        AbstractActor[] actors102 = new AbstractActor[3];
        Sequence sequence103 = new Sequence();
        argOption = (AbstractArgumentOption)sequence103.getOptionManager().findByProperty("name");
        sequence103.setName((String)argOption.valueOf("timing_write"));
        argOption = (AbstractArgumentOption)sequence103.getOptionManager().findByProperty("actors");
        AbstractActor[] actors105 = new AbstractActor[3];
        ContainerValuePicker containervaluepicker106 = new ContainerValuePicker();
        argOption = (AbstractArgumentOption)containervaluepicker106.getOptionManager().findByProperty("valueName");
        containervaluepicker106.setValueName((String)argOption.valueOf("msec"));
        containervaluepicker106.setSwitchOutputs(true);
        actors105[0] = containervaluepicker106;
        MakePlotContainer makeplotcontainer108 = new MakePlotContainer();
        argOption = (AbstractArgumentOption)makeplotcontainer108.getOptionManager().findByProperty("plotName");
        makeplotcontainer108.setPlotName((String)argOption.valueOf("Write speed"));
        actors105[1] = makeplotcontainer108;
        CallableSink callablesink110 = new CallableSink();
        argOption = (AbstractArgumentOption)callablesink110.getOptionManager().findByProperty("callableName");
        callablesink110.setCallableName((CallableActorReference)argOption.valueOf("Write"));
        actors105[2] = callablesink110;
        sequence103.setActors(actors105);
        actors102[0] = sequence103;
        Sequence sequence112 = new Sequence();
        argOption = (AbstractArgumentOption)sequence112.getOptionManager().findByProperty("name");
        sequence112.setName((String)argOption.valueOf("timing_cpuspeed"));
        argOption = (AbstractArgumentOption)sequence112.getOptionManager().findByProperty("actors");
        AbstractActor[] actors114 = new AbstractActor[3];
        ContainerValuePicker containervaluepicker115 = new ContainerValuePicker();
        argOption = (AbstractArgumentOption)containervaluepicker115.getOptionManager().findByProperty("valueName");
        containervaluepicker115.setValueName((String)argOption.valueOf("msec"));
        containervaluepicker115.setSwitchOutputs(true);
        actors114[0] = containervaluepicker115;
        MakePlotContainer makeplotcontainer117 = new MakePlotContainer();
        argOption = (AbstractArgumentOption)makeplotcontainer117.getOptionManager().findByProperty("plotName");
        makeplotcontainer117.setPlotName((String)argOption.valueOf("CPU Speed"));
        actors114[1] = makeplotcontainer117;
        CallableSink callablesink119 = new CallableSink();
        argOption = (AbstractArgumentOption)callablesink119.getOptionManager().findByProperty("callableName");
        callablesink119.setCallableName((CallableActorReference)argOption.valueOf("CPU"));
        actors114[2] = callablesink119;
        sequence112.setActors(actors114);
        actors102[1] = sequence112;
        Sequence sequence121 = new Sequence();
        argOption = (AbstractArgumentOption)sequence121.getOptionManager().findByProperty("name");
        sequence121.setName((String)argOption.valueOf("timing_overall"));
        argOption = (AbstractArgumentOption)sequence121.getOptionManager().findByProperty("actors");
        AbstractActor[] actors123 = new AbstractActor[3];
        ContainerValuePicker containervaluepicker124 = new ContainerValuePicker();
        argOption = (AbstractArgumentOption)containervaluepicker124.getOptionManager().findByProperty("actors");
        AbstractActor[] actors125 = new AbstractActor[1];
        SetVariable setvariable126 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable126.getOptionManager().findByProperty("variableName");
        setvariable126.setVariableName((VariableName)argOption.valueOf("msec"));
        actors125[0] = setvariable126;
        containervaluepicker124.setActors(actors125);
        argOption = (AbstractArgumentOption)containervaluepicker124.getOptionManager().findByProperty("valueName");
        containervaluepicker124.setValueName((String)argOption.valueOf("msec"));
        actors123[0] = containervaluepicker124;
        ContainerValuePicker containervaluepicker129 = new ContainerValuePicker();
        argOption = (AbstractArgumentOption)containervaluepicker129.getOptionManager().findByProperty("name");
        containervaluepicker129.setName((String)argOption.valueOf("ContainerValuePicker-1"));
        argOption = (AbstractArgumentOption)containervaluepicker129.getOptionManager().findByProperty("actors");
        AbstractActor[] actors131 = new AbstractActor[1];
        SetVariable setvariable132 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable132.getOptionManager().findByProperty("variableName");
        setvariable132.setVariableName((VariableName)argOption.valueOf("prefix"));
        actors131[0] = setvariable132;
        containervaluepicker129.setActors(actors131);
        argOption = (AbstractArgumentOption)containervaluepicker129.getOptionManager().findByProperty("valueName");
        containervaluepicker129.setValueName((String)argOption.valueOf("Prefix"));
        actors123[1] = containervaluepicker129;
        Trigger trigger135 = new Trigger();
        argOption = (AbstractArgumentOption)trigger135.getOptionManager().findByProperty("name");
        trigger135.setName((String)argOption.valueOf("generate output"));
        argOption = (AbstractArgumentOption)trigger135.getOptionManager().findByProperty("actors");
        AbstractActor[] actors137 = new AbstractActor[2];
        CombineVariables combinevariables138 = new CombineVariables();
        argOption = (AbstractArgumentOption)combinevariables138.getOptionManager().findByProperty("expression");
        combinevariables138.setExpression((BaseText)argOption.valueOf("Overall @{prefix}: @{msec} msec"));
        actors137[0] = combinevariables138;
        CallableSink callablesink140 = new CallableSink();
        argOption = (AbstractArgumentOption)callablesink140.getOptionManager().findByProperty("callableName");
        callablesink140.setCallableName((CallableActorReference)argOption.valueOf("Overall"));
        actors137[1] = callablesink140;
        trigger135.setActors(actors137);
        actors123[2] = trigger135;
        sequence121.setActors(actors123);
        actors102[2] = sequence121;
        callableactors101.setActors(actors102);
        actors2[1] = callableactors101;
        Standalones standalones142 = new Standalones();
        argOption = (AbstractArgumentOption)standalones142.getOptionManager().findByProperty("name");
        standalones142.setName((String)argOption.valueOf("speed variables"));
        argOption = (AbstractArgumentOption)standalones142.getOptionManager().findByProperty("actors");
        AbstractActor[] actors144 = new AbstractActor[5];
        adams.flow.standalone.SetVariable setvariable145 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable145.getOptionManager().findByProperty("name");
        setvariable145.setName((String)argOption.valueOf("# curves"));
        argOption = (AbstractArgumentOption)setvariable145.getOptionManager().findByProperty("variableName");
        setvariable145.setVariableName((VariableName)argOption.valueOf("num_curves"));
        argOption = (AbstractArgumentOption)setvariable145.getOptionManager().findByProperty("variableValue");
        setvariable145.setVariableValue((BaseText)argOption.valueOf("500"));
        actors144[0] = setvariable145;
        adams.flow.standalone.SetVariable setvariable149 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable149.getOptionManager().findByProperty("name");
        setvariable149.setName((String)argOption.valueOf("# means"));
        argOption = (AbstractArgumentOption)setvariable149.getOptionManager().findByProperty("variableName");
        setvariable149.setVariableName((VariableName)argOption.valueOf("num_means"));
        argOption = (AbstractArgumentOption)setvariable149.getOptionManager().findByProperty("variableValue");
        setvariable149.setVariableValue((BaseText)argOption.valueOf("5"));
        actors144[1] = setvariable149;
        adams.flow.standalone.SetVariable setvariable153 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable153.getOptionManager().findByProperty("name");
        setvariable153.setName((String)argOption.valueOf("# stdevs"));
        argOption = (AbstractArgumentOption)setvariable153.getOptionManager().findByProperty("variableName");
        setvariable153.setVariableName((VariableName)argOption.valueOf("num_stdevs"));
        argOption = (AbstractArgumentOption)setvariable153.getOptionManager().findByProperty("variableValue");
        setvariable153.setVariableValue((BaseText)argOption.valueOf("5"));
        actors144[2] = setvariable153;
        adams.flow.standalone.SetVariable setvariable157 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable157.getOptionManager().findByProperty("name");
        setvariable157.setName((String)argOption.valueOf("# data points"));
        argOption = (AbstractArgumentOption)setvariable157.getOptionManager().findByProperty("variableName");
        setvariable157.setVariableName((VariableName)argOption.valueOf("num_points"));
        argOption = (AbstractArgumentOption)setvariable157.getOptionManager().findByProperty("variableValue");
        setvariable157.setVariableValue((BaseText)argOption.valueOf("200"));
        actors144[3] = setvariable157;
        adams.flow.standalone.SetVariable setvariable161 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable161.getOptionManager().findByProperty("name");
        setvariable161.setName((String)argOption.valueOf("cpu plot update interval"));
        argOption = (AbstractArgumentOption)setvariable161.getOptionManager().findByProperty("variableName");
        setvariable161.setVariableName((VariableName)argOption.valueOf("cpu_plot_update"));
        argOption = (AbstractArgumentOption)setvariable161.getOptionManager().findByProperty("variableValue");
        setvariable161.setVariableValue((BaseText)argOption.valueOf("100"));
        actors144[4] = setvariable161;
        standalones142.setActors(actors144);
        actors2[2] = standalones142;
        Standalones standalones165 = new Standalones();
        argOption = (AbstractArgumentOption)standalones165.getOptionManager().findByProperty("name");
        standalones165.setName((String)argOption.valueOf("write variables"));
        argOption = (AbstractArgumentOption)standalones165.getOptionManager().findByProperty("actors");
        AbstractActor[] actors167 = new AbstractActor[5];
        adams.flow.standalone.SetVariable setvariable168 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable168.getOptionManager().findByProperty("name");
        setvariable168.setName((String)argOption.valueOf("number of files"));
        argOption = (AbstractArgumentOption)setvariable168.getOptionManager().findByProperty("variableName");
        setvariable168.setVariableName((VariableName)argOption.valueOf("num_files"));
        argOption = (AbstractArgumentOption)setvariable168.getOptionManager().findByProperty("variableValue");
        setvariable168.setVariableValue((BaseText)argOption.valueOf("500"));
        actors167[0] = setvariable168;
        adams.flow.standalone.SetVariable setvariable172 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable172.getOptionManager().findByProperty("name");
        setvariable172.setName((String)argOption.valueOf("number of numbers per file"));
        argOption = (AbstractArgumentOption)setvariable172.getOptionManager().findByProperty("variableName");
        setvariable172.setVariableName((VariableName)argOption.valueOf("num_rand"));
        argOption = (AbstractArgumentOption)setvariable172.getOptionManager().findByProperty("variableValue");
        setvariable172.setVariableValue((BaseText)argOption.valueOf("1000"));
        actors167[1] = setvariable172;
        adams.flow.standalone.SetVariable setvariable176 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable176.getOptionManager().findByProperty("name");
        setvariable176.setName((String)argOption.valueOf("combine numbers"));
        argOption = (AbstractArgumentOption)setvariable176.getOptionManager().findByProperty("variableName");
        setvariable176.setVariableName((VariableName)argOption.valueOf("combine_numbers"));
        argOption = (AbstractArgumentOption)setvariable176.getOptionManager().findByProperty("variableValue");
        setvariable176.setVariableValue((BaseText)argOption.valueOf("true"));
        actors167[2] = setvariable176;
        adams.flow.standalone.SetVariable setvariable180 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable180.getOptionManager().findByProperty("name");
        setvariable180.setName((String)argOption.valueOf("output file"));
        argOption = (AbstractArgumentOption)setvariable180.getOptionManager().findByProperty("variableName");
        setvariable180.setVariableName((VariableName)argOption.valueOf("outfile"));
        argOption = (AbstractArgumentOption)setvariable180.getOptionManager().findByProperty("variableValue");
        setvariable180.setVariableValue((BaseText)argOption.valueOf("${TMP}/rand.txt"));
        actors167[3] = setvariable180;
        adams.flow.standalone.SetVariable setvariable184 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable184.getOptionManager().findByProperty("name");
        setvariable184.setName((String)argOption.valueOf("write plot update interval"));
        argOption = (AbstractArgumentOption)setvariable184.getOptionManager().findByProperty("variableName");
        setvariable184.setVariableName((VariableName)argOption.valueOf("write_plot_update"));
        argOption = (AbstractArgumentOption)setvariable184.getOptionManager().findByProperty("variableValue");
        setvariable184.setVariableValue((BaseText)argOption.valueOf("100"));
        actors167[4] = setvariable184;
        standalones165.setActors(actors167);
        actors2[3] = standalones165;
        Start start188 = new Start();
        actors2[4] = start188;
        Trigger trigger189 = new Trigger();
        argOption = (AbstractArgumentOption)trigger189.getOptionManager().findByProperty("name");
        trigger189.setName((String)argOption.valueOf("prompt user"));
        argOption = (AbstractArgumentOption)trigger189.getOptionManager().findByProperty("actors");
        AbstractActor[] actors191 = new AbstractActor[4];
        EnterManyValues entermanyvalues192 = new EnterManyValues();
        argOption = (AbstractArgumentOption)entermanyvalues192.getOptionManager().findByProperty("name");
        entermanyvalues192.setName((String)argOption.valueOf("Enter parameters"));
        entermanyvalues192.setStopFlowIfCanceled(true);
        argOption = (AbstractArgumentOption)entermanyvalues192.getOptionManager().findByProperty("message");
        entermanyvalues192.setMessage((String)argOption.valueOf("Please enter the performance test parameters"));
        argOption = (AbstractArgumentOption)entermanyvalues192.getOptionManager().findByProperty("values");
        ValueDefinition[] values195 = new ValueDefinition[10];
        ValueDefinition valuedefinition196 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition196.getOptionManager().findByProperty("name");
        valuedefinition196.setName((String)argOption.valueOf("num_curves"));
        argOption = (AbstractArgumentOption)valuedefinition196.getOptionManager().findByProperty("display");
        valuedefinition196.setDisplay((String)argOption.valueOf("CPU: # curves"));
        argOption = (AbstractArgumentOption)valuedefinition196.getOptionManager().findByProperty("help");
        valuedefinition196.setHelp((String)argOption.valueOf("The number of bell curves to calculate"));
        argOption = (AbstractArgumentOption)valuedefinition196.getOptionManager().findByProperty("type");
        valuedefinition196.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition196.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_curves}");
        values195[0] = valuedefinition196;
        ValueDefinition valuedefinition201 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition201.getOptionManager().findByProperty("name");
        valuedefinition201.setName((String)argOption.valueOf("num_means"));
        argOption = (AbstractArgumentOption)valuedefinition201.getOptionManager().findByProperty("display");
        valuedefinition201.setDisplay((String)argOption.valueOf("CPU: # means"));
        argOption = (AbstractArgumentOption)valuedefinition201.getOptionManager().findByProperty("help");
        valuedefinition201.setHelp((String)argOption.valueOf("The number of different bell curve means to use in each iteration"));
        argOption = (AbstractArgumentOption)valuedefinition201.getOptionManager().findByProperty("type");
        valuedefinition201.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition201.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_means}");
        values195[1] = valuedefinition201;
        ValueDefinition valuedefinition206 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition206.getOptionManager().findByProperty("name");
        valuedefinition206.setName((String)argOption.valueOf("num_stdevs"));
        argOption = (AbstractArgumentOption)valuedefinition206.getOptionManager().findByProperty("display");
        valuedefinition206.setDisplay((String)argOption.valueOf("CPU: # standard deviations"));
        argOption = (AbstractArgumentOption)valuedefinition206.getOptionManager().findByProperty("help");
        valuedefinition206.setHelp((String)argOption.valueOf("The number of different bell curve standard deviations to use in each iteration"));
        argOption = (AbstractArgumentOption)valuedefinition206.getOptionManager().findByProperty("type");
        valuedefinition206.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition206.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_stdevs}");
        values195[2] = valuedefinition206;
        ValueDefinition valuedefinition211 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition211.getOptionManager().findByProperty("name");
        valuedefinition211.setName((String)argOption.valueOf("num_points"));
        argOption = (AbstractArgumentOption)valuedefinition211.getOptionManager().findByProperty("display");
        valuedefinition211.setDisplay((String)argOption.valueOf("CPU: # data points"));
        argOption = (AbstractArgumentOption)valuedefinition211.getOptionManager().findByProperty("help");
        valuedefinition211.setHelp((String)argOption.valueOf("The number of data points to calculate per bell curve"));
        argOption = (AbstractArgumentOption)valuedefinition211.getOptionManager().findByProperty("type");
        valuedefinition211.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition211.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_points}");
        values195[3] = valuedefinition211;
        ValueDefinition valuedefinition216 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition216.getOptionManager().findByProperty("name");
        valuedefinition216.setName((String)argOption.valueOf("cpu_plot_update"));
        argOption = (AbstractArgumentOption)valuedefinition216.getOptionManager().findByProperty("display");
        valuedefinition216.setDisplay((String)argOption.valueOf("CPU: plot update interval"));
        argOption = (AbstractArgumentOption)valuedefinition216.getOptionManager().findByProperty("help");
        valuedefinition216.setHelp((String)argOption.valueOf("After how many iterations to refresh the plot"));
        argOption = (AbstractArgumentOption)valuedefinition216.getOptionManager().findByProperty("type");
        valuedefinition216.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition216.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{cpu_plot_update}");
        values195[4] = valuedefinition216;
        ValueDefinition valuedefinition221 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition221.getOptionManager().findByProperty("name");
        valuedefinition221.setName((String)argOption.valueOf("num_files"));
        argOption = (AbstractArgumentOption)valuedefinition221.getOptionManager().findByProperty("display");
        valuedefinition221.setDisplay((String)argOption.valueOf("Write: # files"));
        argOption = (AbstractArgumentOption)valuedefinition221.getOptionManager().findByProperty("help");
        valuedefinition221.setHelp((String)argOption.valueOf("The number of files to generate"));
        argOption = (AbstractArgumentOption)valuedefinition221.getOptionManager().findByProperty("type");
        valuedefinition221.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition221.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_files}");
        values195[5] = valuedefinition221;
        ValueDefinition valuedefinition226 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition226.getOptionManager().findByProperty("name");
        valuedefinition226.setName((String)argOption.valueOf("num_rand"));
        argOption = (AbstractArgumentOption)valuedefinition226.getOptionManager().findByProperty("display");
        valuedefinition226.setDisplay((String)argOption.valueOf("Write: # random numbers per file"));
        argOption = (AbstractArgumentOption)valuedefinition226.getOptionManager().findByProperty("help");
        valuedefinition226.setHelp((String)argOption.valueOf("How many random numbers to store in a single file"));
        argOption = (AbstractArgumentOption)valuedefinition226.getOptionManager().findByProperty("type");
        valuedefinition226.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition226.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{num_rand}");
        values195[6] = valuedefinition226;
        ValueDefinition valuedefinition231 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition231.getOptionManager().findByProperty("name");
        valuedefinition231.setName((String)argOption.valueOf("combine_numbers"));
        argOption = (AbstractArgumentOption)valuedefinition231.getOptionManager().findByProperty("display");
        valuedefinition231.setDisplay((String)argOption.valueOf("Write: single write operation per file"));
        argOption = (AbstractArgumentOption)valuedefinition231.getOptionManager().findByProperty("help");
        valuedefinition231.setHelp((String)argOption.valueOf("Whether to save one number at a time or all at once"));
        argOption = (AbstractArgumentOption)valuedefinition231.getOptionManager().findByProperty("type");
        valuedefinition231.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("BOOLEAN")));
        argOption = (AbstractArgumentOption)valuedefinition231.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{combine_numbers}");
        values195[7] = valuedefinition231;
        ValueDefinition valuedefinition236 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition236.getOptionManager().findByProperty("name");
        valuedefinition236.setName((String)argOption.valueOf("outfile"));
        argOption = (AbstractArgumentOption)valuedefinition236.getOptionManager().findByProperty("display");
        valuedefinition236.setDisplay((String)argOption.valueOf("Write: temporary file"));
        argOption = (AbstractArgumentOption)valuedefinition236.getOptionManager().findByProperty("help");
        valuedefinition236.setHelp((String)argOption.valueOf("The temporary to use for saving the random numbers"));
        argOption = (AbstractArgumentOption)valuedefinition236.getOptionManager().findByProperty("type");
        valuedefinition236.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("FILE_ABSOLUTE")));
        argOption = (AbstractArgumentOption)valuedefinition236.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{outfile}");
        values195[8] = valuedefinition236;
        ValueDefinition valuedefinition241 = new ValueDefinition();
        argOption = (AbstractArgumentOption)valuedefinition241.getOptionManager().findByProperty("name");
        valuedefinition241.setName((String)argOption.valueOf("write_plot_update"));
        argOption = (AbstractArgumentOption)valuedefinition241.getOptionManager().findByProperty("display");
        valuedefinition241.setDisplay((String)argOption.valueOf("Write: plot update interval"));
        argOption = (AbstractArgumentOption)valuedefinition241.getOptionManager().findByProperty("help");
        valuedefinition241.setHelp((String)argOption.valueOf("After how many iterations to refresh the plot"));
        argOption = (AbstractArgumentOption)valuedefinition241.getOptionManager().findByProperty("type");
        valuedefinition241.setType((PropertiesParameterPanel.PropertyType)((Object)argOption.valueOf("INTEGER")));
        argOption = (AbstractArgumentOption)valuedefinition241.getOptionManager().findByProperty("defaultValue");
        argOption.setVariable("@{write_plot_update}");
        values195[9] = valuedefinition241;
        entermanyvalues192.setValues(values195);
        argOption = (AbstractArgumentOption)entermanyvalues192.getOptionManager().findByProperty("outputType");
        entermanyvalues192.setOutputType((EnterManyValues.OutputType)((Object)argOption.valueOf("KEY_VALUE_PAIRS")));
        actors191[0] = entermanyvalues192;
        Tee tee247 = new Tee();
        argOption = (AbstractArgumentOption)tee247.getOptionManager().findByProperty("name");
        tee247.setName((String)argOption.valueOf("output param"));
        argOption = (AbstractArgumentOption)tee247.getOptionManager().findByProperty("actors");
        AbstractActor[] actors249 = new AbstractActor[2];
        StringJoin stringjoin250 = new StringJoin();
        argOption = (AbstractArgumentOption)stringjoin250.getOptionManager().findByProperty("glue");
        stringjoin250.setGlue((String)argOption.valueOf(": "));
        actors249[0] = stringjoin250;
        CallableSink callablesink252 = new CallableSink();
        argOption = (AbstractArgumentOption)callablesink252.getOptionManager().findByProperty("callableName");
        callablesink252.setCallableName((CallableActorReference)argOption.valueOf("Overall"));
        actors249[1] = callablesink252;
        tee247.setActors(actors249);
        actors191[1] = tee247;
        Tee tee254 = new Tee();
        argOption = (AbstractArgumentOption)tee254.getOptionManager().findByProperty("name");
        tee254.setName((String)argOption.valueOf("var name"));
        argOption = (AbstractArgumentOption)tee254.getOptionManager().findByProperty("actors");
        AbstractActor[] actors256 = new AbstractActor[2];
        GetArrayElement getarrayelement257 = new GetArrayElement();
        actors256[0] = getarrayelement257;
        SetVariable setvariable258 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable258.getOptionManager().findByProperty("variableName");
        setvariable258.setVariableName((VariableName)argOption.valueOf("name"));
        actors256[1] = setvariable258;
        tee254.setActors(actors256);
        actors191[2] = tee254;
        Tee tee260 = new Tee();
        argOption = (AbstractArgumentOption)tee260.getOptionManager().findByProperty("name");
        tee260.setName((String)argOption.valueOf("var value"));
        argOption = (AbstractArgumentOption)tee260.getOptionManager().findByProperty("actors");
        AbstractActor[] actors262 = new AbstractActor[2];
        GetArrayElement getarrayelement263 = new GetArrayElement();
        argOption = (AbstractArgumentOption)getarrayelement263.getOptionManager().findByProperty("index");
        getarrayelement263.setIndex((Index)argOption.valueOf("2"));
        actors262[0] = getarrayelement263;
        SetVariable setvariable265 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable265.getOptionManager().findByProperty("variableName");
        argOption.setVariable("@{name}");
        actors262[1] = setvariable265;
        tee260.setActors(actors262);
        actors191[3] = tee260;
        trigger189.setActors(actors191);
        actors2[5] = trigger189;
        TimedTrigger timedtrigger266 = new TimedTrigger();
        argOption = (AbstractArgumentOption)timedtrigger266.getOptionManager().findByProperty("name");
        timedtrigger266.setName((String)argOption.valueOf("speed"));
        argOption = (AbstractArgumentOption)timedtrigger266.getOptionManager().findByProperty("actors");
        AbstractActor[] actors268 = new AbstractActor[2];
        ForLoop forloop269 = new ForLoop();
        argOption = (AbstractArgumentOption)forloop269.getOptionManager().findByProperty("loopUpper");
        argOption.setVariable("@{num_curves}");
        actors268[0] = forloop269;
        TimedTrigger timedtrigger270 = new TimedTrigger();
        argOption = (AbstractArgumentOption)timedtrigger270.getOptionManager().findByProperty("name");
        timedtrigger270.setName((String)argOption.valueOf("calc curves"));
        argOption = (AbstractArgumentOption)timedtrigger270.getOptionManager().findByProperty("actors");
        AbstractActor[] actors272 = new AbstractActor[4];
        ForLoop forloop273 = new ForLoop();
        argOption = (AbstractArgumentOption)forloop273.getOptionManager().findByProperty("loopUpper");
        argOption.setVariable("@{num_means}");
        actors272[0] = forloop273;
        MathExpression mathexpression274 = new MathExpression();
        argOption = (AbstractArgumentOption)mathexpression274.getOptionManager().findByProperty("expression");
        mathexpression274.setExpression((MathematicalExpressionText)argOption.valueOf("X / @{num_means}"));
        actors272[1] = mathexpression274;
        SetVariable setvariable276 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable276.getOptionManager().findByProperty("variableName");
        setvariable276.setVariableName((VariableName)argOption.valueOf("mean"));
        actors272[2] = setvariable276;
        Trigger trigger278 = new Trigger();
        argOption = (AbstractArgumentOption)trigger278.getOptionManager().findByProperty("name");
        trigger278.setName((String)argOption.valueOf("mean"));
        argOption = (AbstractArgumentOption)trigger278.getOptionManager().findByProperty("actors");
        AbstractActor[] actors280 = new AbstractActor[4];
        ForLoop forloop281 = new ForLoop();
        argOption = (AbstractArgumentOption)forloop281.getOptionManager().findByProperty("loopUpper");
        argOption.setVariable("@{num_stdevs}");
        actors280[0] = forloop281;
        MathExpression mathexpression282 = new MathExpression();
        argOption = (AbstractArgumentOption)mathexpression282.getOptionManager().findByProperty("expression");
        mathexpression282.setExpression((MathematicalExpressionText)argOption.valueOf("X / @{num_stdevs}"));
        actors280[1] = mathexpression282;
        SetVariable setvariable284 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable284.getOptionManager().findByProperty("variableName");
        setvariable284.setVariableName((VariableName)argOption.valueOf("stdev"));
        actors280[2] = setvariable284;
        Trigger trigger286 = new Trigger();
        argOption = (AbstractArgumentOption)trigger286.getOptionManager().findByProperty("name");
        trigger286.setName((String)argOption.valueOf("stdev"));
        argOption = (AbstractArgumentOption)trigger286.getOptionManager().findByProperty("actors");
        AbstractActor[] actors288 = new AbstractActor[4];
        adams.flow.standalone.SetVariable setvariable289 = new adams.flow.standalone.SetVariable();
        argOption = (AbstractArgumentOption)setvariable289.getOptionManager().findByProperty("name");
        setvariable289.setName((String)argOption.valueOf("plot name"));
        argOption = (AbstractArgumentOption)setvariable289.getOptionManager().findByProperty("variableName");
        setvariable289.setVariableName((VariableName)argOption.valueOf("plot_name"));
        argOption = (AbstractArgumentOption)setvariable289.getOptionManager().findByProperty("variableValue");
        setvariable289.setVariableValue((BaseText)argOption.valueOf("@{mean}/@{stdev}"));
        setvariable289.setExpandValue(true);
        actors288[0] = setvariable289;
        ForLoop forloop293 = new ForLoop();
        argOption = (AbstractArgumentOption)forloop293.getOptionManager().findByProperty("loopLower");
        forloop293.setLoopLower((Integer)argOption.valueOf("0"));
        argOption = (AbstractArgumentOption)forloop293.getOptionManager().findByProperty("loopUpper");
        argOption.setVariable("@{num_points}");
        actors288[1] = forloop293;
        MathExpression mathexpression295 = new MathExpression();
        argOption = (AbstractArgumentOption)mathexpression295.getOptionManager().findByProperty("expression");
        mathexpression295.setExpression((MathematicalExpressionText)argOption.valueOf("(X - (@{num_points} / 2)) / 33"));
        actors288[2] = mathexpression295;
        MathExpression mathexpression297 = new MathExpression();
        argOption = (AbstractArgumentOption)mathexpression297.getOptionManager().findByProperty("name");
        mathexpression297.setName((String)argOption.valueOf("MathExpression-1"));
        argOption = (AbstractArgumentOption)mathexpression297.getOptionManager().findByProperty("expression");
        mathexpression297.setExpression((MathematicalExpressionText)argOption.valueOf("1/sqrt(2*PI*pow(@{stdev},2))*exp(-1*pow(X-@{mean},2)/(2*@{stdev}))"));
        mathexpression297.setOutputValuePair(true);
        actors288[3] = mathexpression297;
        trigger286.setActors(actors288);
        actors280[3] = trigger286;
        trigger278.setActors(actors280);
        actors272[3] = trigger278;
        timedtrigger270.setActors(actors272);
        argOption = (AbstractArgumentOption)timedtrigger270.getOptionManager().findByProperty("callableName");
        timedtrigger270.setCallableName((CallableActorReference)argOption.valueOf("timing_cpuspeed"));
        actors268[1] = timedtrigger270;
        timedtrigger266.setActors(actors268);
        argOption = (AbstractArgumentOption)timedtrigger266.getOptionManager().findByProperty("prefix");
        timedtrigger266.setPrefix((String)argOption.valueOf("CPU"));
        argOption = (AbstractArgumentOption)timedtrigger266.getOptionManager().findByProperty("callableName");
        timedtrigger266.setCallableName((CallableActorReference)argOption.valueOf("timing_overall"));
        actors2[6] = timedtrigger266;
        TimedTrigger timedtrigger303 = new TimedTrigger();
        argOption = (AbstractArgumentOption)timedtrigger303.getOptionManager().findByProperty("name");
        timedtrigger303.setName((String)argOption.valueOf("write"));
        argOption = (AbstractArgumentOption)timedtrigger303.getOptionManager().findByProperty("actors");
        AbstractActor[] actors305 = new AbstractActor[5];
        RandomNumberGenerator randomnumbergenerator306 = new RandomNumberGenerator();
        argOption = (AbstractArgumentOption)randomnumbergenerator306.getOptionManager().findByProperty("generator");
        JavaRandomInt javarandomint308 = new JavaRandomInt();
        randomnumbergenerator306.setGenerator(javarandomint308);
        argOption = (AbstractArgumentOption)randomnumbergenerator306.getOptionManager().findByProperty("maxNum");
        argOption.setVariable("@{num_files}");
        actors305[0] = randomnumbergenerator306;
        Convert convert309 = new Convert();
        argOption = (AbstractArgumentOption)convert309.getOptionManager().findByProperty("conversion");
        DoubleToString doubletostring311 = new DoubleToString();
        argOption = (AbstractArgumentOption)doubletostring311.getOptionManager().findByProperty("numDecimals");
        doubletostring311.setNumDecimals((Integer)argOption.valueOf("0"));
        doubletostring311.setFixedDecimals(true);
        convert309.setConversion(doubletostring311);
        actors305[1] = convert309;
        SetVariable setvariable313 = new SetVariable();
        argOption = (AbstractArgumentOption)setvariable313.getOptionManager().findByProperty("name");
        setvariable313.setName((String)argOption.valueOf("set seed"));
        argOption = (AbstractArgumentOption)setvariable313.getOptionManager().findByProperty("variableName");
        setvariable313.setVariableName((VariableName)argOption.valueOf("seed"));
        actors305[2] = setvariable313;
        Trigger trigger316 = new Trigger();
        argOption = (AbstractArgumentOption)trigger316.getOptionManager().findByProperty("name");
        trigger316.setName((String)argOption.valueOf("delete file"));
        argOption = (AbstractArgumentOption)trigger316.getOptionManager().findByProperty("actors");
        AbstractActor[] actors318 = new AbstractActor[2];
        Variable variable319 = new Variable();
        argOption = (AbstractArgumentOption)variable319.getOptionManager().findByProperty("variableName");
        variable319.setVariableName((VariableName)argOption.valueOf("outfile"));
        actors318[0] = variable319;
        DeleteFile deletefile321 = new DeleteFile();
        actors318[1] = deletefile321;
        trigger316.setActors(actors318);
        actors305[3] = trigger316;
        Trigger trigger322 = new Trigger();
        argOption = (AbstractArgumentOption)trigger322.getOptionManager().findByProperty("name");
        trigger322.setName((String)argOption.valueOf("generate random array"));
        argOption = (AbstractArgumentOption)trigger322.getOptionManager().findByProperty("actors");
        AbstractActor[] actors324 = new AbstractActor[4];
        RandomNumberGenerator randomnumbergenerator325 = new RandomNumberGenerator();
        argOption = (AbstractArgumentOption)randomnumbergenerator325.getOptionManager().findByProperty("generator");
        JavaRandomDouble javarandomdouble327 = new JavaRandomDouble();
        argOption = (AbstractArgumentOption)javarandomdouble327.getOptionManager().findByProperty("seed");
        argOption.setVariable("@{seed}");
        randomnumbergenerator325.setGenerator(javarandomdouble327);
        argOption = (AbstractArgumentOption)randomnumbergenerator325.getOptionManager().findByProperty("maxNum");
        argOption.setVariable("@{num_rand}");
        actors324[0] = randomnumbergenerator325;
        SequenceToArray sequencetoarray328 = new SequenceToArray();
        argOption = (AbstractArgumentOption)sequencetoarray328.getOptionManager().findByProperty("arrayLength");
        argOption.setVariable("@{num_rand}");
        actors324[1] = sequencetoarray328;
        ArrayProcess arrayprocess329 = new ArrayProcess();
        argOption = (AbstractArgumentOption)arrayprocess329.getOptionManager().findByProperty("actors");
        AbstractActor[] actors330 = new AbstractActor[1];
        Convert convert331 = new Convert();
        argOption = (AbstractArgumentOption)convert331.getOptionManager().findByProperty("conversion");
        DoubleToString doubletostring333 = new DoubleToString();
        argOption = (AbstractArgumentOption)doubletostring333.getOptionManager().findByProperty("numDecimals");
        doubletostring333.setNumDecimals((Integer)argOption.valueOf("6"));
        doubletostring333.setFixedDecimals(true);
        convert331.setConversion(doubletostring333);
        actors330[0] = convert331;
        arrayprocess329.setActors(actors330);
        actors324[2] = arrayprocess329;
        TimedTee timedtee335 = new TimedTee();
        argOption = (AbstractArgumentOption)timedtee335.getOptionManager().findByProperty("actors");
        AbstractActor[] actors336 = new AbstractActor[1];
        IfThenElse ifthenelse337 = new IfThenElse();
        argOption = (AbstractArgumentOption)ifthenelse337.getOptionManager().findByProperty("condition");
        Expression expression339 = new Expression();
        argOption = (AbstractArgumentOption)expression339.getOptionManager().findByProperty("expression");
        expression339.setExpression((BooleanExpressionText)argOption.valueOf("(@{combine_numbers})"));
        ifthenelse337.setCondition(expression339);
        argOption = (AbstractArgumentOption)ifthenelse337.getOptionManager().findByProperty("thenActor");
        Sequence sequence342 = new Sequence();
        argOption = (AbstractArgumentOption)sequence342.getOptionManager().findByProperty("name");
        sequence342.setName((String)argOption.valueOf("then"));
        argOption = (AbstractArgumentOption)sequence342.getOptionManager().findByProperty("actors");
        AbstractActor[] actors344 = new AbstractActor[2];
        StringJoin stringjoin345 = new StringJoin();
        argOption = (AbstractArgumentOption)stringjoin345.getOptionManager().findByProperty("glue");
        stringjoin345.setGlue((String)argOption.valueOf("\n"));
        actors344[0] = stringjoin345;
        DumpFile dumpfile347 = new DumpFile();
        argOption = (AbstractArgumentOption)dumpfile347.getOptionManager().findByProperty("outputFile");
        dumpfile347.setOutputFile((PlaceholderFile)argOption.valueOf("${HOME}/temp/rand.txt"));
        dumpfile347.setAppend(true);
        actors344[1] = dumpfile347;
        sequence342.setActors(actors344);
        ifthenelse337.setThenActor(sequence342);
        argOption = (AbstractArgumentOption)ifthenelse337.getOptionManager().findByProperty("elseActor");
        Sequence sequence350 = new Sequence();
        argOption = (AbstractArgumentOption)sequence350.getOptionManager().findByProperty("name");
        sequence350.setName((String)argOption.valueOf("else"));
        argOption = (AbstractArgumentOption)sequence350.getOptionManager().findByProperty("actors");
        AbstractActor[] actors352 = new AbstractActor[2];
        ArrayToSequence arraytosequence353 = new ArrayToSequence();
        actors352[0] = arraytosequence353;
        DumpFile dumpfile354 = new DumpFile();
        argOption = (AbstractArgumentOption)dumpfile354.getOptionManager().findByProperty("outputFile");
        dumpfile354.setOutputFile((PlaceholderFile)argOption.valueOf("${HOME}/temp/rand.txt"));
        dumpfile354.setAppend(true);
        actors352[1] = dumpfile354;
        sequence350.setActors(actors352);
        ifthenelse337.setElseActor(sequence350);
        actors336[0] = ifthenelse337;
        timedtee335.setActors(actors336);
        argOption = (AbstractArgumentOption)timedtee335.getOptionManager().findByProperty("callableName");
        timedtee335.setCallableName((CallableActorReference)argOption.valueOf("timing_write"));
        actors324[3] = timedtee335;
        trigger322.setActors(actors324);
        actors305[4] = trigger322;
        timedtrigger303.setActors(actors305);
        argOption = (AbstractArgumentOption)timedtrigger303.getOptionManager().findByProperty("prefix");
        timedtrigger303.setPrefix((String)argOption.valueOf("Write"));
        argOption = (AbstractArgumentOption)timedtrigger303.getOptionManager().findByProperty("callableName");
        timedtrigger303.setCallableName((CallableActorReference)argOption.valueOf("timing_overall"));
        actors2[7] = timedtrigger303;
        actor.setActors(actors2);
        argOption = (AbstractArgumentOption)actor.getOptionManager().findByProperty("flowExecutionListener");
        NullListener nulllistener360 = new NullListener();
        actor.setFlowExecutionListener(nulllistener360);
        return actor;
    }
}

