/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.DateFormat;
import adams.core.Utils;
import adams.data.image.BufferedImageContainer;
import adams.data.io.output.AbstractImageWriter;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.GUIHelper;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;

public class TakeScreenshot
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = -1502903491659697700L;

    public TakeScreenshot() {
        this(null);
    }

    public TakeScreenshot(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    public String getIconName() {
        return "screenshot.png";
    }

    @Override
    public void launch() {
        try {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rect = new Rectangle(size);
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(rect);
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage(image);
            String file = "ADAMS-" + new DateFormat("yyyyMMdd_HHmmss").format(new Date());
            ImageFileChooser filechooser = new ImageFileChooser();
            filechooser.setSelectedFile(new File(file));
            int retVal = filechooser.showSaveDialog(this.getOwner());
            if (retVal != 0) {
                return;
            }
            AbstractImageWriter writer = filechooser.getImageWriter();
            String msg = writer.write(filechooser.getSelectedPlaceholderFile(), cont);
            if (msg != null) {
                GUIHelper.showErrorMessage(this.getOwner(), "Failed to save screenshot to '" + filechooser.getSelectedPlaceholderFile() + "':\n" + msg);
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(this.getOwner(), "Failed to take screenshot:\n" + Utils.throwableToString(e));
        }
    }

    @Override
    public String getTitle() {
        return "Take screenshot";
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Help";
    }
}

