/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.plugin;

import adams.gui.core.BaseMenu;
import adams.gui.core.GUIHelper;
import adams.gui.plugin.AbstractToolPlugin;
import adams.gui.plugin.ToolPluginSupporter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractToolPluginManager<T extends ToolPluginSupporter, P extends AbstractToolPlugin> {
    protected T m_Owner;
    protected List<P> m_Plugins;
    protected List<JMenuItem> m_MenuItems;
    protected ChangeListener m_MenuUpdateListener;

    protected AbstractToolPluginManager(T owner) {
        this.m_Owner = owner;
        this.m_Plugins = new ArrayList<P>();
        this.m_MenuItems = new ArrayList<JMenuItem>();
        this.m_MenuUpdateListener = null;
    }

    public void setMenuUpdateListener(ChangeListener l) {
        this.m_MenuUpdateListener = l;
    }

    public ChangeListener getMenuUpdateListener() {
        return this.m_MenuUpdateListener;
    }

    public abstract String[] getPlugins();

    public void addToMenuBar(JMenuBar menubar) {
        AbstractToolPlugin plugin;
        int i;
        this.m_MenuItems.clear();
        this.m_Plugins.clear();
        String[] plugins = this.getPlugins();
        ArrayList<String> menuNames = new ArrayList<String>();
        for (i = 0; i < plugins.length; ++i) {
            try {
                plugin = (AbstractToolPlugin)Class.forName(plugins[i]).newInstance();
                this.m_Plugins.add(plugin);
                if (menuNames.contains(plugin.getMenu())) continue;
                menuNames.add(plugin.getMenu());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to install plugin '" + plugins[i] + "':");
                e.printStackTrace();
            }
        }
        Collections.sort(menuNames);
        ArrayList<JMenu> newMenus = new ArrayList<JMenu>();
        HashMap<String, BaseMenu> menus = new HashMap<String, BaseMenu>();
        for (String menuName : menuNames) {
            JMenu menu = null;
            for (int n = 0; n < menubar.getMenuCount(); ++n) {
                if (!menubar.getMenu(n).getText().equals(menuName)) continue;
                menu = menubar.getMenu(n);
                menu.addSeparator();
                break;
            }
            if (menu == null) {
                menu = new BaseMenu(menuName);
                menubar.add(menu);
                menu.setVisible(plugins.length > 0);
                menu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (AbstractToolPluginManager.this.m_MenuUpdateListener != null) {
                            AbstractToolPluginManager.this.m_MenuUpdateListener.stateChanged(e);
                        }
                        AbstractToolPluginManager.this.updateMenu();
                    }
                });
                newMenus.add(menu);
            }
            menus.put(menuName, (BaseMenu)menu);
        }
        for (i = 0; i < this.m_Plugins.size(); ++i) {
            try {
                plugin = (AbstractToolPlugin)this.m_Plugins.get(i);
                JMenuItem menuitem = new JMenuItem(plugin.getCaption());
                menuitem.setIcon(plugin.getIcon());
                ((JMenu)menus.get(plugin.getMenu())).add(menuitem);
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String error = plugin.execute(AbstractToolPluginManager.this.m_Owner.getCurrentPanel());
                        if (error != null && !error.isEmpty()) {
                            GUIHelper.showErrorMessage(AbstractToolPluginManager.this.m_Owner.getCurrentPanel(), "Error occurred executing plugin '" + plugin.getCaption() + "':\n" + error);
                        }
                        AbstractToolPluginManager.this.updateMenu();
                    }
                });
                this.m_MenuItems.add(menuitem);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to install plugin '" + plugins[i] + "':");
                e.printStackTrace();
            }
        }
        for (JMenu m : newMenus) {
            if (!(m instanceof BaseMenu)) continue;
            ((BaseMenu)m).sort();
        }
    }

    public void updateMenu() {
        for (int i = 0; i < this.m_Plugins.size(); ++i) {
            try {
                boolean enabled = ((AbstractToolPlugin)this.m_Plugins.get(i)).canExecute(this.m_Owner.getCurrentPanel());
                this.m_MenuItems.get(i).setEnabled(enabled);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to update plugin: " + ((AbstractToolPlugin)this.m_Plugins.get(i)).getClass().getName());
                e.printStackTrace();
            }
        }
    }
}

