/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.io.FileUtils;
import adams.gui.print.PostscriptGraphics;
import adams.gui.print.ScalableComponentWriter;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;

public class PostscriptWriter
extends ScalableComponentWriter {
    private static final long serialVersionUID = -8501713979661829063L;

    @Override
    public String globalInfo() {
        return "Outputs EPS files.";
    }

    @Override
    public String getDescription() {
        return "Postscript-File";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".eps"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateOutput() throws Exception {
        BufferedOutputStream ostrm = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getFile().getAbsoluteFile());
            ostrm = new BufferedOutputStream(fos);
            PostscriptGraphics psg = new PostscriptGraphics(this.getComponent().getHeight(), this.getComponent().getWidth(), ostrm);
            psg.setFont(this.getComponent().getFont());
            psg.scale(this.getXScale(), this.getYScale());
            this.getComponent().printAll(psg);
            psg.finished();
        }
        catch (Exception e) {
            try {
                System.err.println(e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(ostrm);
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly(ostrm);
            FileUtils.closeQuietly(fos);
        }
        FileUtils.closeQuietly(ostrm);
        FileUtils.closeQuietly(fos);
    }
}

