/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.FieldType;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.db.FieldProvider;
import adams.gui.event.FieldCacheUpdateEvent;
import adams.gui.event.FieldCacheUpdateListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class AbstractFieldCacheItem
implements Serializable,
DatabaseConnectionProvider {
    private static final long serialVersionUID = 6989601817204575826L;
    protected FieldProvider m_Provider;
    protected Hashtable<FieldType, Vector<AbstractField>> m_Values;
    protected Hashtable<FieldType, HashSet<FieldCacheUpdateListener>> m_CacheListeners;

    public AbstractFieldCacheItem(FieldProvider provider) {
        this.m_Provider = provider;
        this.m_Values = null;
        this.m_CacheListeners = new Hashtable();
        for (FieldType type : FieldType.values()) {
            this.m_CacheListeners.put(type, new HashSet());
        }
    }

    public FieldProvider getFieldProvider() {
        return this.m_Provider;
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_Provider.getDatabaseConnection();
    }

    public void clear() {
        if (this.m_Values != null) {
            this.m_Values.clear();
        }
        this.m_Values = null;
    }

    public boolean isInitialized() {
        return this.m_Values != null;
    }

    public Hashtable<FieldType, Vector<AbstractField>> getValues() {
        try {
            this.initCache();
        }
        catch (Exception e) {
            this.m_Values = this.newCache();
            System.err.println("Failed to initialized field cache for " + this.m_Provider.getDatabaseConnection().toStringShort() + ":");
            e.printStackTrace();
        }
        return this.m_Values;
    }

    public Vector<AbstractField> getValues(FieldType fieldType) {
        return this.getValues().get((Object)fieldType);
    }

    public Vector<AbstractField> getValues(FieldType fieldType, DataType dataType) {
        Vector<AbstractField> result = new Vector<AbstractField>();
        Vector<AbstractField> values = this.getValues(fieldType);
        for (AbstractField field : values) {
            if (field.getDataType() != dataType) continue;
            result.add(field);
        }
        return result;
    }

    protected Hashtable<FieldType, Vector<AbstractField>> newCache() {
        Hashtable<FieldType, Vector<AbstractField>> result = new Hashtable<FieldType, Vector<AbstractField>>();
        for (FieldType type : FieldType.values()) {
            result.put(type, new Vector());
        }
        return result;
    }

    protected abstract AbstractField newField(AbstractField var1);

    protected abstract AbstractField newSuffixField(AbstractField var1);

    protected abstract AbstractField newPrefixField(AbstractField var1);

    protected void initCache() {
        if (this.m_Values == null) {
            Vector<Object> fields = this.getFieldProvider() == null || !this.getFieldProvider().getDatabaseConnection().isConnected() ? new Vector() : this.getFieldProvider().getFields();
            this.m_Values = this.newCache();
            for (int i = 0; i < fields.size(); ++i) {
                AbstractField field = this.newField((AbstractField)fields.get(i));
                this.m_Values.get((Object)FieldType.FIELD).add(field);
                if (!((AbstractField)fields.get(i)).isCompound()) continue;
                field = this.newPrefixField((AbstractField)fields.get(i));
                if (!this.m_Values.get((Object)FieldType.PREFIX_FIELD).contains(field)) {
                    this.m_Values.get((Object)FieldType.PREFIX_FIELD).add(field);
                }
                field = this.newSuffixField((AbstractField)fields.get(i));
                if (this.m_Values.get((Object)FieldType.SUFFIX_FIELD).contains(field)) continue;
                this.m_Values.get((Object)FieldType.SUFFIX_FIELD).add(field);
            }
            for (FieldType type : FieldType.values()) {
                Collections.sort((List)this.m_Values.get((Object)type));
            }
            for (FieldType type : FieldType.values()) {
                FieldCacheUpdateEvent event = new FieldCacheUpdateEvent(this);
                Iterator<FieldCacheUpdateListener> iter = this.m_CacheListeners.get((Object)type).iterator();
                while (iter.hasNext()) {
                    iter.next().cacheUpdated(event);
                }
            }
        }
    }

    public void addCacheListener(FieldType fieldtype, FieldCacheUpdateListener l) {
        this.m_CacheListeners.get((Object)fieldtype).add(l);
    }

    public void removeCacheListener(FieldType fieldtype, FieldCacheUpdateListener l) {
        this.m_CacheListeners.get((Object)fieldtype).remove(l);
    }

    public void removeCacheListeners() {
        this.m_CacheListeners.clear();
    }
}

