/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedProducer;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingCommandCode;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.tools.AbstractTool;
import adams.tools.InitializeTables;
import adams.tools.RunTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractRunToolPanel
extends BasePanel
implements ScriptingEngineHandler {
    private static final long serialVersionUID = -7309370485661269159L;
    protected AbstractTool m_CurrentTool;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentTool = new InitializeTables();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        GenericObjectEditorPanel panelTool = new GenericObjectEditorPanel(AbstractTool.class, this.m_CurrentTool, true);
        panelTool.setPrefix("Tool");
        panelTool.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractRunToolPanel.this.m_CurrentTool = (AbstractTool)((GenericObjectEditorPanel)e.getSource()).getCurrent();
            }
        });
        panelTool.setPopupMenuCustomizer(new AbstractChooserPanel.PopupMenuCustomizer(){

            @Override
            public void customizePopupMenu(AbstractChooserPanel owner, JPopupMenu menu) {
                JMenuItem item = new JMenuItem("Copy RunTool setup to clipboard");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RunTool runTool = AbstractRunToolPanel.this.getRunTool();
                        runTool.setTool(AbstractRunToolPanel.this.m_CurrentTool);
                        GUIHelper.copyToClipboard(AbstractOptionProducer.toString(NestedProducer.class, runTool));
                    }
                });
                menu.addSeparator();
                menu.add(item);
            }
        });
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRunToolPanel.this.closeParent();
                AbstractRunToolPanel.this.run(AbstractRunToolPanel.this.m_CurrentTool);
            }
        });
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.setMnemonic('C');
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRunToolPanel.this.closeParent();
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel2.add((Component)panelTool, "Center");
        this.add((Component)panel2, "North");
        panel2 = new JPanel(new BorderLayout());
        this.add((Component)panel2, "South");
        JPanel panel = new JPanel(new FlowLayout(2));
        panel2.add((Component)panel, "North");
        panel.add(buttonOK);
        panel.add(buttonCancel);
    }

    protected RunTool getRunTool() {
        return new RunTool();
    }

    protected void run(AbstractTool tool) {
        if (tool == null) {
            return;
        }
        this.getScriptingEngine().add(null, "run-tool " + OptionUtils.getCommandLine(tool), new ScriptingCommandCode(){

            @Override
            public void execute() {
                GUIHelper.showInformationMessage(AbstractRunToolPanel.this, "Execution of tool finished!");
            }
        });
    }

    @Override
    public abstract AbstractScriptingEngine getScriptingEngine();
}

