/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Variables;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTableWithButtons;
import adams.gui.core.ClearableModel;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.parser.BooleanExpression;
import adams.parser.MathematicalExpression;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExpressionWatchPanel
extends BasePanel {
    private static final long serialVersionUID = -1541211757878841209L;
    protected TableModel m_ExpressionsModel;
    protected BaseTableWithButtons m_Table;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonRefresh;
    protected JButton m_ButtonRefreshAll;
    protected ExpressionDialog m_DialogExpression;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ExpressionsModel = new TableModel(new Variables());
        this.m_Table = new BaseTableWithButtons(this.m_ExpressionsModel);
        this.m_Table.setAutoResizeMode(0);
        this.m_Table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExpressionWatchPanel.this.updateButtons();
            }
        });
        this.add((Component)this.m_Table, "Center");
        this.m_ButtonAdd = new JButton("Add...");
        this.m_ButtonAdd.setMnemonic('A');
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.addExpression();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ButtonEdit = new JButton("Edit...");
        this.m_ButtonEdit.setMnemonic('E');
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.updateExpression();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonEdit);
        this.m_Table.setDoubleClickButton(this.m_ButtonEdit);
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.setMnemonic('R');
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.removeSelectedExpressions();
            }
        });
        this.m_Table.addToButtonsPanel(new JLabel());
        this.m_Table.addToButtonsPanel(this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.setMnemonic('m');
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.removeAllExpressions();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonRemoveAll);
        this.m_ButtonRefresh = new JButton("Refresh");
        this.m_ButtonRefresh.setMnemonic('f');
        this.m_ButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.refreshSelectedExpressions();
            }
        });
        this.m_Table.addToButtonsPanel(new JLabel());
        this.m_Table.addToButtonsPanel(this.m_ButtonRefresh);
        this.m_ButtonRefreshAll = new JButton("Refresh all");
        this.m_ButtonRefreshAll.setMnemonic('l');
        this.m_ButtonRefreshAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionWatchPanel.this.refreshAllExpressions();
            }
        });
        this.m_Table.addToButtonsPanel(this.m_ButtonRefreshAll);
        this.m_Table.setOptimalColumnWidth();
        this.updateButtons();
    }

    protected void updateButtons() {
        int numSel = this.m_Table.getSelectedRowCount();
        int total = this.m_Table.getRowCount();
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonEdit.setEnabled(numSel == 1);
        this.m_ButtonRemove.setEnabled(numSel > 0);
        this.m_ButtonRemoveAll.setEnabled(total > 0);
        this.m_ButtonRefresh.setEnabled(numSel > 0);
        this.m_ButtonRefreshAll.setEnabled(total > 0);
    }

    protected void initExpressionDialog() {
        if (this.m_DialogExpression == null) {
            this.m_DialogExpression = this.getParentDialog() != null ? new ExpressionDialog(this.getParentDialog()) : new ExpressionDialog(this.getParentFrame());
            this.m_DialogExpression.setLocationRelativeTo(this);
        }
    }

    public void addExpression() {
        this.initExpressionDialog();
        this.m_DialogExpression.reset();
        this.m_DialogExpression.setVisible(true);
        if (this.m_DialogExpression.getOption() != 0) {
            return;
        }
        this.addExpression(this.m_DialogExpression.getExpression(), this.m_DialogExpression.getExpressionType());
    }

    public boolean addExpression(String expr, ExpressionType type) {
        if (!this.hasExpression(expr, type)) {
            this.m_ExpressionsModel.addExpression(expr, type);
            this.m_Table.setOptimalColumnWidth();
            return true;
        }
        return false;
    }

    public boolean hasExpression(String expr, ExpressionType type) {
        boolean result = false;
        expr = this.m_ExpressionsModel.fixExpression(expr, type);
        for (int i = 0; i < this.m_ExpressionsModel.getRowCount(); ++i) {
            if (!this.m_ExpressionsModel.getExpressionAt(i).equals(expr) || this.m_ExpressionsModel.getTypeAt(i) != type) continue;
            result = true;
            break;
        }
        return result;
    }

    public void updateExpression() {
        this.initExpressionDialog();
        int index = this.m_Table.getSelectedRow();
        if (index == -1) {
            return;
        }
        this.m_DialogExpression.setExpression(this.m_ExpressionsModel.getExpressionAt(index));
        this.m_DialogExpression.setExpressionType(this.m_ExpressionsModel.getTypeAt(index));
        this.m_DialogExpression.setVisible(true);
        if (this.m_DialogExpression.getOption() != 0) {
            return;
        }
        this.m_ExpressionsModel.updateExpression(index, this.m_DialogExpression.getExpression(), this.m_DialogExpression.getExpressionType());
        this.m_Table.setOptimalColumnWidth();
    }

    public void removeSelectedExpressions() {
        int[] indices = this.m_Table.getSelectedRows();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ExpressionsModel.removeExpression(indices[i]);
        }
    }

    public void removeAllExpressions() {
        this.m_ExpressionsModel.clear();
    }

    public void refreshSelectedExpressions() {
        int[] indices = this.m_Table.getSelectedRows();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ExpressionsModel.refreshExpression(indices[i]);
        }
    }

    public void refreshAllExpressions() {
        this.m_ExpressionsModel.refreshAllExpressions();
    }

    public void setVariables(Variables value) {
        this.m_ExpressionsModel.setVariables(value);
    }

    public Variables getVariables() {
        return this.m_ExpressionsModel.getVariables();
    }

    public static enum ExpressionType {
        VARIABLE,
        BOOLEAN,
        NUMERIC,
        STRING;

    }

    public static class ExpressionDialog
    extends ApprovalDialog {
        private static final long serialVersionUID = -8201358257732667201L;
        protected JTextField m_TextExpression;
        protected JComboBox m_ComboBoxType;

        public ExpressionDialog(Dialog owner) {
            super(owner, Dialog.ModalityType.DOCUMENT_MODAL);
        }

        public ExpressionDialog(Frame owner) {
            super(owner, true);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Watch expression");
            ParameterPanel panel = new ParameterPanel();
            this.getContentPane().add(panel);
            this.m_TextExpression = new JTextField(30);
            this.m_TextExpression.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateButtons();
                }
            });
            panel.addParameter("_Expression", this.m_TextExpression);
            this.m_ComboBoxType = new JComboBox<ExpressionType>(ExpressionType.values());
            this.m_ComboBoxType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateButtons();
                }
            });
            panel.addParameter("_Type", this.m_ComboBoxType);
            this.pack();
        }

        public void setExpression(String value) {
            this.m_TextExpression.setText(value);
        }

        public String getExpression() {
            return this.m_TextExpression.getText();
        }

        public void setExpressionType(ExpressionType value) {
            this.m_ComboBoxType.setSelectedItem((Object)value);
        }

        public ExpressionType getExpressionType() {
            return (ExpressionType)((Object)this.m_ComboBoxType.getSelectedItem());
        }

        public void reset() {
            this.m_TextExpression.setText("");
            this.m_ComboBoxType.setSelectedIndex(0);
        }

        public void updateButtons() {
            this.m_ButtonApprove.setEnabled(this.m_TextExpression.getText().length() > 0 && this.m_ComboBoxType.getSelectedIndex() != -1);
            this.m_ButtonCancel.setEnabled(true);
        }
    }

    public static class TableModel
    extends AbstractBaseTableModel
    implements ClearableModel {
        private static final long serialVersionUID = -7414970810033285323L;
        protected Vector<String> m_Expressions = new Vector();
        protected Vector<ExpressionType> m_Types = new Vector();
        protected Vector<Object> m_Values = new Vector();
        protected Variables m_Variables;

        public TableModel(Variables variables) {
            this.m_Variables = variables;
        }

        public void setVariables(Variables value) {
            this.m_Variables = value;
            this.fireTableDataChanged();
        }

        public Variables getVariables() {
            return this.m_Variables;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.m_Expressions.size();
        }

        protected synchronized void refreshExpression(int rowIndex, boolean fireUpdate) {
            String expr = this.getExpressionAt(rowIndex);
            ExpressionType type = this.getTypeAt(rowIndex);
            switch (type) {
                case VARIABLE: {
                    this.m_Values.set(rowIndex, this.getVariables().get(expr));
                    break;
                }
                case BOOLEAN: {
                    try {
                        expr = this.getVariables().expand(expr);
                        boolean boolValue = BooleanExpression.evaluate(expr, new HashMap());
                        this.m_Values.set(rowIndex, boolValue);
                    }
                    catch (Exception e) {
                        System.err.println("Error evaluating boolean expression: " + expr);
                        e.printStackTrace();
                    }
                    break;
                }
                case NUMERIC: {
                    try {
                        expr = this.getVariables().expand(expr);
                        double numValue = MathematicalExpression.evaluate(expr, new HashMap());
                        this.m_Values.set(rowIndex, numValue);
                    }
                    catch (Exception e) {
                        System.err.println("Error evaluating numeric expression: " + expr);
                        e.printStackTrace();
                    }
                    break;
                }
                case STRING: {
                    this.m_Values.set(rowIndex, this.getVariables().expand(expr));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled expression type: " + (Object)((Object)type));
                }
            }
            if (fireUpdate) {
                this.fireTableCellUpdated(rowIndex, 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void refreshExpression(int rowIndex) {
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                this.refreshExpression(rowIndex, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void refreshAllExpressions() {
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                for (int i = 0; i < this.m_Expressions.size(); ++i) {
                    this.refreshExpression(i, false);
                }
            }
            this.fireTableDataChanged();
        }

        public String getExpressionAt(int rowIndex) {
            return this.m_Expressions.get(rowIndex);
        }

        public ExpressionType getTypeAt(int rowIndex) {
            return this.m_Types.get(rowIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.m_Expressions.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.m_Types.get(rowIndex).toString();
            }
            if (columnIndex == 2) {
                if (this.m_Values.get(rowIndex) == null) {
                    this.refreshExpression(rowIndex, false);
                }
                return this.m_Values.get(rowIndex);
            }
            throw new IllegalArgumentException("Invalid column index: " + columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Expression";
            }
            if (column == 1) {
                return "Type";
            }
            if (column == 2) {
                return "Value";
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return Object.class;
            }
            throw new IllegalArgumentException("Invalid column index: " + columnIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void clear() {
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                this.m_Values.clear();
                this.m_Types.clear();
                this.m_Expressions.clear();
            }
        }

        public String fixExpression(String expr, ExpressionType type) {
            if (type == ExpressionType.VARIABLE && expr.startsWith("(") && expr.endsWith(")")) {
                expr = expr.substring(1, expr.length() - 1);
            }
            return expr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addExpression(String expr, ExpressionType type) {
            expr = this.fixExpression(expr, type);
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                this.m_Values.add(null);
                this.m_Types.add(type);
                this.m_Expressions.add(expr);
            }
            this.fireTableRowsInserted(this.m_Expressions.size() - 1, this.m_Expressions.size() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updateExpression(int rowIndex, String expr, ExpressionType type) {
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                this.m_Values.set(rowIndex, null);
                this.m_Types.set(rowIndex, type);
                this.m_Expressions.set(rowIndex, expr);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void removeExpression(int rowIndex) {
            Vector<String> vector = this.m_Expressions;
            synchronized (vector) {
                this.m_Values.remove(rowIndex);
                this.m_Types.remove(rowIndex);
                this.m_Expressions.remove(rowIndex);
            }
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }
}

