/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.DefaultSimpleCSVReportReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.report.Report;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.io.File;
import java.util.List;

public class ReportHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 8930638838922218410L;

    @Override
    public String globalInfo() {
        return "Displays report files: " + Utils.arrayToString(this.getExtensions());
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"report", "csv"};
    }

    @Override
    protected PreviewPanel createPreview(File file) {
        List reports;
        BasePanel result = new BasePanel(new BorderLayout());
        if (file.getName().endsWith("csv")) {
            DefaultSimpleCSVReportReader simpleCSV = new DefaultSimpleCSVReportReader();
            simpleCSV.setInput(new PlaceholderFile(file));
            reports = simpleCSV.read();
        } else {
            DefaultSimpleReportReader simple = new DefaultSimpleReportReader();
            simple.setInput(new PlaceholderFile(file));
            reports = simple.read();
        }
        ReportFactory.Model model = reports.size() == 0 ? new ReportFactory.Model() : new ReportFactory.Model((Report)reports.get(0));
        ReportFactory.Table table = new ReportFactory.Table(model);
        table.setAutoResizeMode(0);
        table.setOptimalColumnWidth();
        result.add(new BaseScrollPane(table));
        return new PreviewPanel(result, table);
    }
}

