/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.io.PlaceholderFile;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractPaintlet;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class BackgroundImagePaintlet
extends AbstractPaintlet {
    private static final long serialVersionUID = 7533482742917264993L;
    protected PlaceholderFile m_ImageFile;
    protected transient Image m_Image;
    protected boolean m_UseFixedSize;

    @Override
    public String globalInfo() {
        return "Paints an image located in a file as background.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image-file", "imageFile", new PlaceholderFile());
        this.m_OptionManager.add("use-fixed-size", "useFixedSize", false);
    }

    public void setImageFile(PlaceholderFile value) {
        this.m_ImageFile = value;
        this.reset();
    }

    public PlaceholderFile getImageFile() {
        return this.m_ImageFile;
    }

    public String imageFileTipText() {
        return "The image file to load and use as background.";
    }

    public void setUseFixedSize(boolean value) {
        this.m_UseFixedSize = value;
        this.reset();
    }

    public boolean getUseFixedSize() {
        return this.m_UseFixedSize;
    }

    public String useFixedSizeTipText() {
        return "Whether to use a fixed size image or to resize according to canvas.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.BACKGROUND;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Image == null) {
            if (this.m_ImageFile.isDirectory() || !this.m_ImageFile.exists()) {
                return;
            }
            try {
                this.m_Image = ImageIO.read(new File(this.m_ImageFile.getAbsolutePath()));
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to load background image from '" + this.m_ImageFile + "'!", e);
                return;
            }
        }
        if (this.m_UseFixedSize) {
            g.drawImage(this.m_Image, 0, 0, null);
        } else {
            g.drawImage(this.m_Image, 0, 0, this.getPlot().getWidth(), this.getPlot().getHeight(), null);
        }
    }
}

