/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractStrokePaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;

public class HorizontalIndicatorPaintlet
extends AbstractStrokePaintlet {
    private static final long serialVersionUID = 1590879510204857918L;
    protected Color m_Color;
    protected double m_Value;
    protected boolean m_Percentage;

    @Override
    public String globalInfo() {
        return "Paints a horizontal indicator line at a specified y value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", Color.BLUE);
        this.m_OptionManager.add("value", "value", 1.0, null, null);
        this.m_OptionManager.add("percentage", "percentage", false);
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.memberChanged();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the indicator.";
    }

    public void setValue(double value) {
        this.m_Value = value;
        this.memberChanged();
    }

    public double getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The y-value for the line.";
    }

    public void setPercentage(boolean value) {
        this.m_Percentage = value;
        this.memberChanged();
    }

    public boolean getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "If enabled, the y-value gets interpreted as percentage (0-1) instead of absolute value; this is based on the min/max of the y axis.";
    }

    @Override
    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.GRID;
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        AxisPanel axis = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(this.m_Color);
        if (this.m_Percentage) {
            double pos = (axis.getMaximum() - axis.getMinimum()) * this.m_Value + axis.getMinimum();
            g.drawLine(0, axis.valueToPos(pos), this.getPlot().getWidth() - 1, axis.valueToPos(pos));
        } else {
            g.drawLine(0, axis.valueToPos(this.m_Value), this.getPlot().getWidth() - 1, axis.valueToPos(this.m_Value));
        }
    }
}

