/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectexport;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.core.io.FileFormatHandler;
import adams.core.option.AbstractOptionHandler;
import adams.gui.visualization.debug.objectexport.PlainTextExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractObjectExporter
extends AbstractOptionHandler
implements FileFormatHandler {
    private static final long serialVersionUID = -7742758428210374232L;
    protected static Hashtable<Class, List<Class>> m_Cache = new Hashtable();
    protected static String[] m_Exporters = null;
    protected static Class[] m_ExporterClasses = null;

    protected static synchronized void initExporters() {
        if (m_Exporters != null) {
            return;
        }
        m_Exporters = ClassLister.getSingleton().getClassnames(AbstractObjectExporter.class);
        m_ExporterClasses = new Class[m_Exporters.length];
        for (int i = 0; i < m_Exporters.length; ++i) {
            try {
                AbstractObjectExporter.m_ExporterClasses[i] = Class.forName(m_Exporters[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object exporter '" + m_Exporters[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized List<AbstractObjectExporter> getExporter(Object obj) {
        if (obj != null) {
            return AbstractObjectExporter.getExporter(obj.getClass());
        }
        return AbstractObjectExporter.getExporter(Object.class);
    }

    protected static List<AbstractObjectExporter> instantiate(List<Class> exporters) {
        ArrayList<AbstractObjectExporter> result = new ArrayList<AbstractObjectExporter>();
        for (int i = 0; i < exporters.size(); ++i) {
            try {
                result.add((AbstractObjectExporter)exporters.get(i).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object exporter '" + exporters.get(i).getName() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static synchronized List<AbstractObjectExporter> getExporter(Class cls) {
        AbstractObjectExporter.initExporters();
        if (m_Cache.containsKey(cls)) {
            return AbstractObjectExporter.instantiate(m_Cache.get(cls));
        }
        ArrayList<Class> exporters = new ArrayList<Class>();
        for (int i = 0; i < m_ExporterClasses.length; ++i) {
            if (m_ExporterClasses[i] == PlainTextExporter.class) continue;
            try {
                AbstractObjectExporter exporter = (AbstractObjectExporter)m_ExporterClasses[i].newInstance();
                if (!exporter.handles(cls)) continue;
                exporters.add(m_ExporterClasses[i]);
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object exporter '" + m_ExporterClasses[i].getName() + "':");
                e.printStackTrace();
            }
        }
        if (exporters.size() == 0) {
            exporters.add(PlainTextExporter.class);
        }
        m_Cache.put(cls, exporters);
        return AbstractObjectExporter.instantiate(exporters);
    }

    @Override
    public String globalInfo() {
        return "Export format: " + this.getFormatDescription() + "\n" + "Extension(s): " + Utils.flatten(this.getFormatExtensions(), ", ") + "\n" + "Default extension: " + this.getDefaultFormatExtension();
    }

    @Override
    public abstract String getFormatDescription();

    @Override
    public abstract String[] getFormatExtensions();

    @Override
    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    public abstract boolean handles(Class var1);

    protected abstract String doExport(Object var1, File var2);

    public String export(Object obj, File file) {
        if (obj == null) {
            return "No object provided!";
        }
        return this.doExport(obj, file);
    }

    public static String[] getExporters() {
        return ClassLister.getSingleton().getClassnames(AbstractObjectExporter.class);
    }
}

