/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectexport;

import adams.core.io.FileUtils;
import adams.gui.visualization.debug.objectexport.AbstractObjectExporter;
import adams.gui.visualization.debug.objecttree.AbstractObjectPlainTextRenderer;
import java.io.File;
import java.util.List;

public class RenderedPlainTextExporter
extends AbstractObjectExporter {
    private static final long serialVersionUID = 4899389310274830738L;

    @Override
    public String getFormatDescription() {
        return "Plain text (rendered)";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"txt"};
    }

    @Override
    public boolean handles(Class cls) {
        return AbstractObjectPlainTextRenderer.getRenderer(cls).size() > 0;
    }

    @Override
    protected String doExport(Object obj, File file) {
        List<AbstractObjectPlainTextRenderer> list = AbstractObjectPlainTextRenderer.getRenderer(obj.getClass());
        String rendered = list.get(0).render(obj);
        return FileUtils.writeToFileMsg(file.getAbsolutePath(), rendered, false, null);
    }
}

