/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.core.ClassLister;
import adams.core.logging.LoggingObject;
import adams.gui.visualization.debug.objectrenderer.PlainTextRenderer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;

public abstract class AbstractObjectRenderer
extends LoggingObject {
    private static final long serialVersionUID = -7742758428210374232L;
    protected static Hashtable<Class, List<Class>> m_Cache = new Hashtable();
    protected static String[] m_Renderers = null;
    protected static Class[] m_RendererClasses = null;

    protected static synchronized void initRenderers() {
        if (m_Renderers != null) {
            return;
        }
        m_Renderers = ClassLister.getSingleton().getClassnames(AbstractObjectRenderer.class);
        m_RendererClasses = new Class[m_Renderers.length];
        for (int i = 0; i < m_Renderers.length; ++i) {
            try {
                AbstractObjectRenderer.m_RendererClasses[i] = Class.forName(m_Renderers[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object renderer '" + m_Renderers[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized List<AbstractObjectRenderer> getRenderer(Object obj) {
        if (obj != null) {
            return AbstractObjectRenderer.getRenderer(obj.getClass());
        }
        return AbstractObjectRenderer.getRenderer(Object.class);
    }

    protected static List<AbstractObjectRenderer> instantiate(List<Class> renderers) {
        ArrayList<AbstractObjectRenderer> result = new ArrayList<AbstractObjectRenderer>();
        for (int i = 0; i < renderers.size(); ++i) {
            try {
                result.add((AbstractObjectRenderer)renderers.get(i).newInstance());
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object renderer '" + renderers.get(i).getName() + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    public static synchronized List<AbstractObjectRenderer> getRenderer(Class cls) {
        AbstractObjectRenderer.initRenderers();
        if (m_Cache.containsKey(cls)) {
            return AbstractObjectRenderer.instantiate(m_Cache.get(cls));
        }
        ArrayList<Class> renderers = new ArrayList<Class>();
        for (int i = 0; i < m_RendererClasses.length; ++i) {
            if (m_RendererClasses[i] == PlainTextRenderer.class) continue;
            try {
                AbstractObjectRenderer renderer = (AbstractObjectRenderer)m_RendererClasses[i].newInstance();
                if (!renderer.handles(cls)) continue;
                renderers.add(m_RendererClasses[i]);
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate object renderer '" + m_RendererClasses[i].getName() + "':");
                e.printStackTrace();
            }
        }
        if (renderers.size() == 0) {
            renderers.add(PlainTextRenderer.class);
        }
        m_Cache.put(cls, renderers);
        return AbstractObjectRenderer.instantiate(renderers);
    }

    public abstract boolean handles(Class var1);

    protected abstract String doRender(Object var1, JPanel var2);

    public String render(Object obj, JPanel panel) {
        String result;
        if (obj == null) {
            result = "No object provided!";
        } else {
            result = this.doRender(obj, panel);
            if (result == null) {
                panel.invalidate();
                panel.validate();
                panel.repaint();
            }
        }
        return result;
    }

    public static String[] getRenderers() {
        return ClassLister.getSingleton().getClassnames(AbstractObjectRenderer.class);
    }
}

