/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class HighlightLocations
extends AbstractImageOverlay {
    private static final long serialVersionUID = -3086529802660906811L;
    protected List<Point> m_Locations;
    protected float m_StrokeThickness;
    protected int m_Diameter;
    protected Color m_Color;

    @Override
    public String globalInfo() {
        return "Highlights the specified locations in the image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stroke-thickness", "strokeThickness", Float.valueOf(1.0f), Float.valueOf(0.01f), null);
        this.m_OptionManager.add("diameter", "diameter", 5, 1, null);
        this.m_OptionManager.add("color", "color", Color.RED);
    }

    public void setStrokeThickness(float value) {
        this.m_StrokeThickness = value;
        this.reset();
    }

    public float getStrokeThickness() {
        return this.m_StrokeThickness;
    }

    public String strokeThicknessTipText() {
        return "The thickness of the stroke.";
    }

    public void setDiameter(int value) {
        this.m_Diameter = value;
        this.reset();
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circles in pixels.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color of the circles.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Locations = new ArrayList<Point>();
    }

    public void setLocations(List<Point> value) {
        this.m_Locations = value == null ? new ArrayList<Point>() : new ArrayList<Point>(value);
    }

    public List<Point> getLocations() {
        return this.m_Locations;
    }

    @Override
    protected void doImageChanged(ImagePanel.PaintPanel panel) {
    }

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Locations.size() == 0) {
            return;
        }
        Graphics2D g2d = null;
        float width = 1.0f;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            if (g2d.getStroke() instanceof BasicStroke) {
                width = ((BasicStroke)g2d.getStroke()).getLineWidth();
            }
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
        }
        g.setColor(this.m_Color);
        for (Point loc : this.m_Locations) {
            g.drawOval((int)loc.getX() - this.m_Diameter / 2, (int)loc.getY() - this.m_Diameter / 2, this.m_Diameter, this.m_Diameter);
        }
        if (g2d != null) {
            g2d.setStroke(new BasicStroke(width));
        }
    }
}

