/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesViewerPlugin;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;

public abstract class AbstractSelectedImagesFilter
extends AbstractSelectedImagesViewerPlugin {
    private static final long serialVersionUID = 869121794905442017L;
    protected String m_FilterError;

    @Override
    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected abstract BufferedImage filter(BufferedImage var1);

    @Override
    protected String process(ImagePanel panel) {
        String result = null;
        BufferedImage input = panel.getCurrentImage();
        double scale = panel.getScale();
        this.m_FilterError = null;
        try {
            BufferedImage output = this.filter(input);
            if (output == null) {
                result = "Failed to filter image: ";
                result = this.m_FilterError == null ? result + "unknown reason" : result + this.m_FilterError;
            } else {
                panel.addUndoPoint("Saving undo data...", "Filtering image: " + this.getCaption());
                File file = panel.getCurrentFile();
                panel.setCurrentImage(output);
                panel.setCurrentFile(file);
                panel.setModified(true);
                panel.setScale(scale);
                panel.showStatus("");
            }
        }
        catch (Exception e) {
            this.m_FilterError = e.toString();
            result = "Failed to filter image: ";
            this.getLogger().log(Level.SEVERE, result, e);
            result = result + this.m_FilterError;
        }
        return result;
    }
}

