/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ImageViewerPanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractSelectedImagesViewerPlugin
extends AbstractImageViewerPlugin {
    private static final long serialVersionUID = 869121794905442017L;
    protected ImagePanel[] m_SelectedPanels;

    @Override
    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected ImagePanel[] getAllPanels() {
        ArrayList<ImagePanel> result = new ArrayList<ImagePanel>();
        ImageViewerPanel owner = (ImageViewerPanel)GUIHelper.getParent(this.m_CurrentPanel, ImageViewerPanel.class);
        if (owner != null) {
            result.addAll(Arrays.asList(owner.getAllPanels()));
        }
        return result.toArray(new ImagePanel[result.size()]);
    }

    protected JPanel createListPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        final ImagePanel[] panels = this.getAllPanels();
        DefaultListModel<String> model = new DefaultListModel<String>();
        int index = -1;
        for (ImagePanel p : panels) {
            if (p == this.m_CurrentPanel) {
                index = model.getSize();
            }
            model.addElement(model.getSize() + 1 + ": " + (p.getCurrentFile() == null ? "---" : p.getCurrentFile().getName()));
        }
        final JList list = new JList(model);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indices = list.getSelectedIndices();
                AbstractSelectedImagesViewerPlugin.this.m_SelectedPanels = new ImagePanel[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    AbstractSelectedImagesViewerPlugin.this.m_SelectedPanels[i] = panels[indices[i]];
                }
            }
        });
        list.setSelectedIndex(index);
        BaseScrollPane scrollPane = new BaseScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 1));
        result.add((Component)scrollPane, "Center");
        return result;
    }

    protected abstract JPanel createConfigurationPanel(ApprovalDialog var1);

    protected Dimension getDialogSize() {
        return new Dimension(600, 400);
    }

    protected boolean hasApprovalButton() {
        return true;
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected ApprovalDialog createDialog() {
        ApprovalDialog result = ((ImagePanel)this.m_CurrentPanel).getParentDialog() != null ? new ApprovalDialog(((ImagePanel)this.m_CurrentPanel).getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(((ImagePanel)this.m_CurrentPanel).getParentFrame(), true);
        result.setTitle(this.getCaption());
        result.setApproveVisible(this.hasApprovalButton());
        result.setCancelVisible(this.hasCancelButton());
        result.setDiscardVisible(false);
        result.setSize(this.getDialogSize());
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel("Please select:"));
        result.getContentPane().add((Component)panel, "North");
        panel = new JPanel(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        JPanel panelList = this.createListPanel(result);
        panelList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelConfig = this.createConfigurationPanel(result);
        if (panelConfig == null) {
            panel.add((Component)panelList, "Center");
        } else {
            panel.add((Component)panelList, "West");
            panel.add((Component)panelConfig, "Center");
        }
        return result;
    }

    protected String processInit() {
        return null;
    }

    protected abstract String process(ImagePanel var1);

    protected String processFinish() {
        return null;
    }

    protected String process() {
        String result = this.processInit();
        if (result == null) {
            ImagePanel panel;
            ImagePanel[] imagePanelArray = this.m_SelectedPanels;
            int n = imagePanelArray.length;
            for (int i = 0; i < n && (result = this.process(panel = imagePanelArray[i])) == null; ++i) {
            }
        }
        if (result == null) {
            result = this.processFinish();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        ApprovalDialog dialog = this.createDialog();
        if (dialog == null) {
            result = "Failed to create dialog!";
        } else {
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.getOption() == 0) {
                result = this.process();
            } else if (dialog.getOption() == 2) {
                this.m_CanceledByUser = true;
            }
        }
        return result;
    }
}

