/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.core.BaseDialog;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.image.HighlightLocations;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.PropertySheetPanelPage;
import adams.gui.wizard.TextAreaPage;
import adams.gui.wizard.WizardPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class MarkLocation
extends AbstractImageViewerPlugin {
    private static final long serialVersionUID = -4461021007662529135L;

    @Override
    public String getMenu() {
        return "View";
    }

    @Override
    public String getCaption() {
        return "Mark locations...";
    }

    @Override
    public String getIconName() {
        return "locations.png";
    }

    @Override
    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    @Override
    protected String createLogEntry() {
        return null;
    }

    protected void showHighlights(Properties props) {
        try {
            HighlightLocations overlay = (HighlightLocations)OptionUtils.forAnyCommandLine(HighlightLocations.class, props.getProperty("Commandline", OptionUtils.getCommandLine(new HighlightLocations())));
            String[] lines = props.getProperty("text", "").split("\n");
            ArrayList<Point> locations = new ArrayList<Point>();
            for (String line : lines) {
                String[] parts;
                if ((line = line.trim().replaceAll("  ", " ")).isEmpty() || (parts = line.indexOf(59) > -1 ? line.split(";") : (line.indexOf(44) > -1 ? line.split(",") : (line.indexOf(9) > -1 ? line.split("\t") : line.split(" ")))).length != 2) continue;
                locations.add(new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            }
            overlay.setLocations(locations);
            ((ImagePanel)this.m_CurrentPanel).removeImageOverlays(HighlightLocations.class);
            ((ImagePanel)this.m_CurrentPanel).addImageOverlay(overlay);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(null, "Failed to process locations/overlay setup:\n" + props + "\n" + Utils.throwableToString(e));
        }
    }

    @Override
    protected String doExecute() {
        final BaseDialog dialog = new BaseDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
        final WizardPane wizard = new WizardPane();
        TextAreaPage textpage = new TextAreaPage("Locations");
        textpage.setDescription("Please enter all the locations that you want to highlight.\nEach location must consist of X and Y.\nYou can use whitespaces (blank or tab), comma or semicolon to separate X and Y.");
        wizard.addPage(textpage);
        PropertySheetPanelPage overlaypage = new PropertySheetPanelPage("Overlay");
        overlaypage.setDescription("Please configure the overlay for highlighting the locations.");
        HighlightLocations overlay = new HighlightLocations();
        overlaypage.setTarget(overlay);
        wizard.addPage(overlaypage);
        FinalPage finalpage = new FinalPage();
        finalpage.setLogo(null);
        finalpage.setDescription("<html><h2>Finish</h2>Please click <b>Finish</b> to highlight the locations.");
        wizard.addPage(finalpage);
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Finish")) {
                    Properties props = wizard.getProperties(false);
                    MarkLocation.this.setLastSetup(props);
                    MarkLocation.this.showHighlights(props);
                }
                dialog.setVisible(false);
            }
        });
        Properties props = (Properties)this.getLastSetup();
        if (props != null) {
            try {
                overlay = (HighlightLocations)OptionUtils.forAnyCommandLine(HighlightLocations.class, props.getProperty("Commandline", OptionUtils.getCommandLine(overlay)));
                overlaypage.setTarget(overlay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            textpage.setText(props.getProperty("text", ""));
        }
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)wizard, "Center");
        dialog.setTitle("Mark locations");
        dialog.setSize(600, 500);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        return null;
    }
}

