/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report;

import adams.data.id.DatabaseIDHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.gui.core.BaseTable;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.ContainerWithComponent;
import adams.gui.visualization.container.DatabaseContainer;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.report.ReportContainerManager;

public class ReportContainer
extends AbstractContainer
implements NamedContainer,
ContainerWithComponent<BaseTable>,
DatabaseContainer {
    private static final long serialVersionUID = -7972340961639418611L;
    protected boolean m_Visible;
    protected String m_ID;
    protected BaseTable m_Table;

    public ReportContainer(ReportContainerManager manager, Report report) {
        super(manager, report);
    }

    public ReportContainer(ReportContainerManager manager, ReportHandler handler) {
        this(manager, (Report)handler.getReport());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Table = null;
        this.m_Visible = true;
        this.m_ID = this.getReport() != null ? "" + this.getReport().getDatabaseID() : "-1";
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.m_Table = null;
    }

    public Report getReport() {
        return (Report)this.getPayload();
    }

    public void setVisible(boolean value) {
        this.m_Visible = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.VISIBILITY, this.getManager().indexOf(this)));
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    @Override
    public void setID(String value) {
        this.m_ID = value;
    }

    @Override
    public String getID() {
        return this.m_ID;
    }

    @Override
    public String getDisplayID() {
        return this.getID();
    }

    public boolean hasDatabaseID() {
        return this.getPayload() instanceof DatabaseIDHandler;
    }

    @Override
    public int getDatabaseID() {
        if (this.getPayload() instanceof DatabaseIDHandler) {
            return ((DatabaseIDHandler)((Object)this.getPayload())).getDatabaseID();
        }
        return -1;
    }

    @Override
    public boolean hasComponent() {
        return this.m_Table != null;
    }

    @Override
    public void setComponent(BaseTable value) {
        this.m_Table = value;
    }

    @Override
    public BaseTable getComponent() {
        return this.m_Table;
    }
}

