/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.report;

import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.ReportProvider;
import adams.gui.chooser.AbstractReportFileChooser;
import adams.gui.chooser.DefaultReportFileChooser;
import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchParameters;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ContainerModel;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.DataContainerPanelWithSidePanel;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.report.ReportContainer;
import adams.gui.visualization.report.ReportContainerList;
import adams.gui.visualization.report.ReportContainerManager;
import adams.gui.visualization.report.reportfactory.AbstractTableAction;
import adams.gui.visualization.report.reportfactory.AddField;
import adams.gui.visualization.report.reportfactory.CopyFieldName;
import adams.gui.visualization.report.reportfactory.CopyFieldValue;
import adams.gui.visualization.report.reportfactory.ExcludedFlag;
import adams.gui.visualization.report.reportfactory.ModifyValue;
import adams.gui.visualization.report.reportfactory.PrintReport;
import adams.gui.visualization.report.reportfactory.RemoveField;
import adams.gui.visualization.report.reportfactory.SaveReport;
import adams.gui.visualization.report.reportfactory.ViewValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ReportFactory {
    public static Model getModel(Report report) {
        return new Model(report);
    }

    public static Table getTable(Report report) {
        return new Table(report);
    }

    public static BasePanel getPanel(Report report) {
        BasePanel result = new BasePanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final Table table = new Table(new Model(report));
        result.add((Component)new BaseScrollPane(table), "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        result.add((Component)panel, "South");
        final SearchPanel searchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        searchPanel.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                table.search(searchPanel.getSearchText(), searchPanel.isRegularExpression());
                searchPanel.grabFocus();
            }
        });
        panel.add(searchPanel);
        return result;
    }

    public static Panel getPanel(List<ReportContainer> reports) {
        Panel result = new Panel();
        result.setData(reports);
        return result;
    }

    public static Panel getPanelForReports(List reports) {
        Panel result = new Panel();
        result.setReports(reports);
        return result;
    }

    public static Dialog getDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new Dialog(owner, modality);
    }

    public static Dialog getDialog(Frame owner, boolean modal) {
        return new Dialog(owner, modal);
    }

    public static StandardsDialog getStandardsDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
        return new StandardsDialog(owner, modality);
    }

    public static StandardsDialog getStandardsDialog(Frame owner, boolean modal) {
        return new StandardsDialog(owner, modal);
    }

    public static class StandardsDialog
    extends BaseDialog {
        private static final long serialVersionUID = -4658524307287732983L;
        protected StandardsDialog m_Self;
        protected JPanel m_PanelValues;
        protected JLabel m_LabelCompounds;
        protected JComboBox m_ComboBoxCompounds;
        protected JLabel m_LabelMinValue;
        protected JTextField m_TextMinValue;
        protected JLabel m_LabelMaxValue;
        protected JTextField m_TextMaxValue;
        protected JButton m_ButtonAdd;
        protected JButton m_ButtonRemove;
        protected JButton m_ButtonOK;
        protected JButton m_ButtonCancel;
        protected Field m_SelectedCompound;
        protected JList m_ListCompounds;
        protected DefaultListModel m_ModelCompounds;
        protected boolean m_Canceled;

        public StandardsDialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public StandardsDialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Self = this;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Standards");
            this.getContentPane().setLayout(new BorderLayout());
            this.m_PanelValues = new JPanel(new GridLayout(4, 1));
            this.getContentPane().add((Component)this.m_PanelValues, "West");
            this.m_ComboBoxCompounds = new JComboBox(new DefaultComboBoxModel());
            this.m_LabelCompounds = new JLabel("Compound");
            this.m_LabelCompounds.setDisplayedMnemonic('C');
            this.m_LabelCompounds.setLabelFor(this.m_ComboBoxCompounds);
            JPanel panel = new JPanel(new FlowLayout(0));
            this.m_PanelValues.add(panel);
            panel.add(this.m_LabelCompounds);
            panel.add(this.m_ComboBoxCompounds);
            this.m_TextMinValue = new JTextField(10);
            this.m_TextMinValue.setToolTipText("Use -1 to ignore - gets automatically ignored if no compound selected");
            this.m_LabelMinValue = new JLabel("Minimum value");
            this.m_LabelMinValue.setDisplayedMnemonic('i');
            this.m_LabelMinValue.setLabelFor(this.m_TextMinValue);
            panel = new JPanel(new FlowLayout(0));
            this.m_PanelValues.add(panel);
            panel.add(this.m_LabelMinValue);
            panel.add(this.m_TextMinValue);
            this.m_TextMaxValue = new JTextField(10);
            this.m_TextMaxValue.setToolTipText("Use -1 to ignore - gets automatically ignored if no compound selected");
            this.m_LabelMaxValue = new JLabel("Maximum value");
            this.m_LabelMaxValue.setDisplayedMnemonic('a');
            this.m_LabelMaxValue.setLabelFor(this.m_TextMaxValue);
            panel = new JPanel(new FlowLayout(0));
            this.m_PanelValues.add(panel);
            panel.add(this.m_LabelMaxValue);
            panel.add(this.m_TextMaxValue);
            this.m_ButtonAdd = new JButton("Add");
            this.m_ButtonAdd.setMnemonic('A');
            this.m_ButtonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (m_ComboBoxCompounds.getSelectedIndex() == -1) {
                        return;
                    }
                    double min = -1.0;
                    double max = -1.0;
                    if (m_TextMinValue.getText().length() > 0) {
                        min = Utils.toDouble(m_TextMinValue.getText());
                    }
                    if (m_TextMaxValue.getText().length() > 0) {
                        max = Utils.toDouble(m_TextMaxValue.getText());
                    }
                    m_ModelCompounds.addElement(m_ComboBoxCompounds.getSelectedItem() + " " + min + " " + max);
                }
            });
            panel = new JPanel(new FlowLayout(0));
            panel.add(this.m_ButtonAdd);
            this.m_PanelValues.add(panel);
            this.m_ModelCompounds = new DefaultListModel();
            this.m_ModelCompounds.addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.update();
                }

                protected void update() {
                    m_ButtonOK.setEnabled(m_ModelCompounds.getSize() > 0);
                }
            });
            this.m_ListCompounds = new JList(this.m_ModelCompounds);
            this.m_ListCompounds.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    m_ButtonRemove.setEnabled(m_ListCompounds.getSelectedIndices().length > 0);
                }
            });
            panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)new BaseScrollPane(this.m_ListCompounds), "Center");
            this.getContentPane().add((Component)panel, "Center");
            this.m_ButtonRemove = new JButton("Remove");
            this.m_ButtonRemove.setMnemonic('R');
            this.m_ButtonRemove.setEnabled(false);
            this.m_ButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] indices = m_ListCompounds.getSelectedIndices();
                    for (int i = indices.length - 1; i >= 0; --i) {
                        m_ModelCompounds.remove(indices[i]);
                    }
                }
            });
            panel = new JPanel(new BorderLayout());
            panel.add((Component)this.m_ButtonRemove, "North");
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)panel, "East");
            panel = new JPanel(new FlowLayout(2));
            this.getContentPane().add((Component)panel, "South");
            this.m_ButtonOK = new JButton("OK");
            this.m_ButtonOK.setMnemonic('O');
            this.m_ButtonOK.setEnabled(false);
            this.m_ButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_Canceled = false;
                    if (m_ComboBoxCompounds.getSelectedIndex() > 0) {
                        m_SelectedCompound = (Field)m_ComboBoxCompounds.getSelectedItem();
                    }
                    m_Self.setVisible(false);
                }
            });
            panel.add(this.m_ButtonOK);
            this.m_ButtonCancel = new JButton("Cancel", GUIHelper.getIcon("exit.png"));
            this.m_ButtonCancel.setMnemonic('a');
            this.m_ButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    m_Self.setVisible(false);
                }
            });
            panel.add(this.m_ButtonCancel);
            this.pack();
            this.m_LabelCompounds.setPreferredSize(this.m_LabelMaxValue.getPreferredSize());
            this.m_LabelMinValue.setPreferredSize(this.m_LabelMaxValue.getPreferredSize());
            this.setLocationRelativeTo(this.getOwner());
        }

        public synchronized void setCompounds(List<Field> value) {
            ArrayList<Field> list = new ArrayList<Field>();
            list.add(new Field());
            list.addAll(value);
            this.m_ComboBoxCompounds.setModel(new DefaultComboBoxModel<Field>(list.toArray(new Field[list.size()])));
            if (!this.isVisible()) {
                this.pack();
                this.setLocationRelativeTo(this.getOwner());
                GUIHelper.setSizeAndLocation(this, this);
            }
        }

        public List<Field> getCompounds() {
            ArrayList<Field> result = new ArrayList<Field>();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_ComboBoxCompounds.getModel();
            for (int i = 1; i < model.getSize(); ++i) {
                result.add((Field)model.getElementAt(i));
            }
            return result;
        }

        public void setMinValue(Double value) {
            if (value == null) {
                this.m_TextMinValue.setText("");
            } else {
                this.m_TextMinValue.setText(value.toString());
            }
        }

        public Double getMinValue() {
            Double result = null;
            if (this.m_TextMinValue.getText().length() != 0) {
                try {
                    result = Double.parseDouble(this.m_TextMinValue.getText());
                }
                catch (Exception e) {
                    result = null;
                    e.printStackTrace();
                }
            }
            return result;
        }

        public void setMaxValue(Double value) {
            if (value == null) {
                this.m_TextMaxValue.setText("");
            } else {
                this.m_TextMaxValue.setText(value.toString());
            }
        }

        public Double getMaxValue() {
            Double result = null;
            if (this.m_TextMaxValue.getText().length() != 0) {
                try {
                    result = Double.parseDouble(this.m_TextMaxValue.getText());
                }
                catch (Exception e) {
                    result = null;
                    e.printStackTrace();
                }
            }
            return result;
        }

        public Field getSelectedCompound() {
            return this.m_SelectedCompound;
        }

        public List<String> getSetup() {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.m_ModelCompounds.getSize(); ++i) {
                result.add((String)this.m_ModelCompounds.get(i));
            }
            return result;
        }

        public boolean getCanceled() {
            return this.m_Canceled;
        }

        @Override
        protected void beforeShow() {
            super.beforeShow();
            this.m_SelectedCompound = null;
            this.m_Canceled = true;
        }
    }

    public static class Dialog<C extends ReportContainer, M extends ReportContainerManager>
    extends BaseDialog {
        private static final long serialVersionUID = 377068894443930941L;
        protected Dialog m_Self;
        protected Panel<C, M> m_Panel;
        protected SearchPanel m_SearchPanel;

        public Dialog(java.awt.Dialog owner, Dialog.ModalityType modality) {
            super(owner, modality);
        }

        public Dialog(Frame owner, boolean modal) {
            super(owner, modal);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.m_Self = this;
        }

        protected Panel<C, M> newPanel() {
            return ReportFactory.getPanel((List<ReportContainer>)null);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setTitle("Report");
            this.getContentPane().setLayout(new BorderLayout());
            this.m_Panel = this.newPanel();
            this.getContentPane().add(this.m_Panel, "Center");
            this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            this.m_SearchPanel.addSearchListener(new SearchListener(){

                @Override
                public void searchInitiated(SearchEvent e) {
                    m_Panel.search(m_SearchPanel.getSearchText(), m_SearchPanel.isRegularExpression());
                    m_SearchPanel.grabFocus();
                }
            });
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.add(this.m_SearchPanel);
            this.getContentPane().add((Component)panel, "South");
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public void setContainerManager(M value) {
            this.m_Panel.setContainerManager(value);
        }

        public M getContainerManager() {
            return this.m_Panel.getContainerManager();
        }

        public void setDataContainerPanel(DataContainerPanel value) {
            this.m_Panel.setDataContainerPanel(value);
        }

        public DataContainerPanel getDataContainerPanel() {
            return this.m_Panel.getDataContainerPanel();
        }

        public void setDividerLocation(int value) {
            this.m_Panel.setDividerLocation(value);
        }

        public void setDividerLocation(double value) {
            this.m_Panel.setDividerLocation(value);
        }

        public int getDividerLocation() {
            return this.m_Panel.getDividerLocation();
        }

        public void setReportContainerListWidth(int width) {
            this.m_Panel.setReportContainerListWidth(width);
        }

        public synchronized void setData(List<C> value) {
            this.m_Panel.setData(value);
            if (!this.isVisible()) {
                this.pack();
                this.setLocationRelativeTo(this.getOwner());
                GUIHelper.setSizeAndLocation(this, this);
            }
        }

        public List<C> getData() {
            return this.m_Panel.getData();
        }

        @Override
        protected void beforeShow() {
            ReportContainer cont;
            int index;
            super.beforeShow();
            M manager = this.m_Panel.getContainerManager();
            if (((ReportContainerManager)manager).countVisible() > 0 && (index = ((AbstractContainerManager)manager).indexOf((ReportContainer)(cont = ((ReportContainerManager)manager).getVisible(0)))) > -1) {
                this.m_Panel.showTable(index);
                this.pack();
                this.m_Panel.selectTable(index);
            }
            this.m_SearchPanel.grabFocus();
        }
    }

    public static class Panel<C extends ReportContainer, M extends ReportContainerManager>
    extends BasePanel
    implements DataChangeListener {
        private static final long serialVersionUID = -2563183937371175033L;
        protected M m_ContainerManager;
        protected boolean m_VisibilityManager;
        protected String m_SearchString;
        protected boolean m_RegExp;
        protected BaseSplitPane m_SplitPane;
        protected BasePanel m_PanelTable;
        protected ReportContainerList m_ReportContainerList;
        protected DataContainerPanel m_DataContainerPanel;

        @Override
        protected void initialize() {
            super.initialize();
            this.m_SearchString = null;
            this.m_RegExp = false;
            this.m_ContainerManager = this.newContainerManager();
            this.m_VisibilityManager = this.m_ContainerManager instanceof VisibilityContainerManager;
            this.m_DataContainerPanel = null;
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_SplitPane = new BaseSplitPane(1);
            this.m_SplitPane.setResizeWeight(1.0);
            this.m_SplitPane.setOneTouchExpandable(true);
            this.add((Component)this.m_SplitPane, "Center");
            this.m_PanelTable = new BasePanel(new BorderLayout());
            this.m_SplitPane.setLeftComponent(this.m_PanelTable);
            this.m_ReportContainerList = new ReportContainerList();
            this.m_ReportContainerList.setManager(this.getContainerManager());
            this.m_ReportContainerList.setSelectionMode(0);
            this.m_ReportContainerList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.showTable(m_ReportContainerList.getTable().getSelectedRow());
                }
            });
            this.m_ReportContainerList.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (m_ReportContainerList.getTable().getRowCount() == 0) {
                        this.showTable(-1);
                    }
                }
            });
            this.m_SplitPane.setRightComponent(this.m_ReportContainerList);
        }

        public void setDataContainerPanel(DataContainerPanel value) {
            if (value != null) {
                if (value instanceof DataContainerPanelWithSidePanel) {
                    int width = (int)((DataContainerPanelWithSidePanel)value).getSidePanel().getPreferredSize().getWidth();
                    this.m_ReportContainerList.setPreferredSize(new Dimension(width, 0));
                }
                ((AbstractContainerManager)value.getContainerManager()).addDataChangeListener(this);
                ((ContainerModel)this.m_ReportContainerList.getTable().getModel()).setDisplayVisibility(true);
            } else {
                if (this.m_DataContainerPanel != null) {
                    ((AbstractContainerManager)this.m_DataContainerPanel.getContainerManager()).removeDataChangeListener(this);
                }
                ((ContainerModel)this.m_ReportContainerList.getTable().getModel()).setDisplayVisibility(false);
            }
            this.m_DataContainerPanel = value;
            for (int i = 0; i < ((ReportContainerManager)this.m_ReportContainerList.getManager()).count(); ++i) {
                if (!((ReportContainer)((ReportContainerManager)this.m_ReportContainerList.getManager()).get(i)).hasComponent()) continue;
                ((Table)((ReportContainer)((ReportContainerManager)this.m_ReportContainerList.getManager()).get(i)).getComponent()).setDataContainerPanel(value);
            }
        }

        public DataContainerPanel getDataContainerPanel() {
            return this.m_DataContainerPanel;
        }

        public void setDividerLocation(int value) {
            this.m_SplitPane.setDividerLocation(value);
        }

        public void setDividerLocation(double value) {
            this.m_SplitPane.setDividerLocation(value);
        }

        public int getDividerLocation() {
            return this.m_SplitPane.getDividerLocation();
        }

        protected M newContainerManager() {
            if (this.getDataContainerPanel() != null) {
                return (M)new ReportContainerManager(this.getDataContainerPanel().getDatabaseConnection());
            }
            return (M)new ReportContainerManager(DatabaseConnection.getSingleton());
        }

        public M getContainerManager() {
            return this.m_ContainerManager;
        }

        public void setContainerManager(M value) {
            if (this.m_ContainerManager != null) {
                ((AbstractContainerManager)this.m_ContainerManager).removeDataChangeListener(this);
            }
            this.m_ContainerManager = value;
            this.m_VisibilityManager = false;
            if (this.m_ContainerManager != null) {
                ((AbstractContainerManager)this.m_ContainerManager).addDataChangeListener(this);
                this.m_VisibilityManager = this.m_ContainerManager instanceof VisibilityContainerManager;
            }
        }

        public ReportContainerList getReportContainerList() {
            return this.m_ReportContainerList;
        }

        public void setReportContainerListWidth(int width) {
            this.m_ReportContainerList.setPreferredSize(new Dimension(width, 0));
        }

        public synchronized void setData(List<C> data) {
            ArrayList<ReportContainer> conts = new ArrayList<ReportContainer>();
            if (data != null) {
                for (ReportContainer cont : data) {
                    conts.add(cont);
                }
            }
            ((AbstractContainerManager)this.m_ContainerManager).clear();
            ((AbstractContainerManager)this.m_ContainerManager).addAll(conts);
        }

        public synchronized void setReports(List<Report> data) {
            ArrayList<ReportContainer> conts = new ArrayList<ReportContainer>();
            if (data != null) {
                for (Report report : data) {
                    ReportContainer rcont = ((ReportContainerManager)this.getContainerManager()).newContainer(report);
                    rcont.setID("" + report.getDatabaseID());
                    conts.add(rcont);
                }
            }
            ((AbstractContainerManager)this.m_ContainerManager).clear();
            ((AbstractContainerManager)this.m_ContainerManager).addAll(conts);
        }

        public List<C> getData() {
            ArrayList<ReportContainer> result = new ArrayList<ReportContainer>();
            for (int i = 0; i < ((AbstractContainerManager)this.getContainerManager()).count(); ++i) {
                result.add((ReportContainer)((AbstractContainerManager)this.getContainerManager()).get(i));
            }
            return result;
        }

        public void search(String searchString, boolean regexp) {
            this.m_SearchString = searchString;
            this.m_RegExp = regexp;
            Table table = this.getCurrentTable();
            if (table != null) {
                table.search(searchString, regexp);
            }
        }

        public String getSeachString() {
            return this.m_SearchString;
        }

        @Override
        public void dataChanged(DataChangeEvent e) {
            int[] indices = e.getIndices();
            AbstractContainerManager manager = e.getManager();
            switch (e.getType()) {
                case CLEAR: {
                    ((AbstractContainerManager)this.getContainerManager()).clear();
                    break;
                }
                case ADDITION: {
                    for (int i = 0; i < indices.length; ++i) {
                        Object cont = manager.get(indices[i]);
                        Object report = ((ReportHandler)((Object)((AbstractContainer)cont).getPayload())).getReport();
                        if (report == null) continue;
                        ReportContainer rcont = ((ReportContainerManager)this.getContainerManager()).newContainer((Comparable)report);
                        rcont.setID(((NamedContainer)cont).getID());
                        if (cont instanceof VisibilityContainer) {
                            rcont.setVisible(((VisibilityContainer)cont).isVisible());
                        }
                        ((AbstractContainerManager)this.getContainerManager()).add((ReportContainer)rcont);
                    }
                    break;
                }
                case REMOVAL: {
                    for (int i = indices.length - 1; i >= 0; --i) {
                        ((AbstractContainerManager)this.getContainerManager()).remove(indices[i]);
                    }
                    break;
                }
                case REPLACEMENT: {
                    for (int i = 0; i < indices.length; ++i) {
                        Object cont = manager.get(indices[i]);
                        Object report = ((ReportHandler)((Object)((AbstractContainer)cont).getPayload())).getReport();
                        ReportContainer rcont = ((ReportContainerManager)this.getContainerManager()).newContainer((Comparable)report);
                        rcont.setID(((NamedContainer)cont).getID());
                        if (cont instanceof VisibilityContainer) {
                            rcont.setVisible(((VisibilityContainer)cont).isVisible());
                        }
                        ((AbstractContainerManager)this.getContainerManager()).set(indices[i], (ReportContainer)rcont);
                    }
                    break;
                }
                case VISIBILITY: {
                    for (int i = 0; i < indices.length; ++i) {
                        Object cont = manager.get(indices[i]);
                        ((ReportContainerManager)this.getContainerManager()).setVisible(indices[i], ((VisibilityContainer)cont).isVisible());
                    }
                    break;
                }
                case UPDATE: {
                    for (int i = 0; i < indices.length; ++i) {
                        Object cont = manager.get(indices[i]);
                        Object report = ((ReportHandler)((Object)((AbstractContainer)cont).getPayload())).getReport();
                        ReportContainer rcont = (ReportContainer)((AbstractContainerManager)this.getContainerManager()).get(indices[i]);
                        rcont.setPayload((Comparable)report);
                        rcont.setID(((NamedContainer)cont).getID());
                        if (cont instanceof VisibilityContainer) {
                            rcont.setVisible(((VisibilityContainer)cont).isVisible());
                        }
                        ((AbstractContainerManager)this.getContainerManager()).set(indices[i], (ReportContainer)rcont);
                    }
                    break;
                }
                case BULK_UPDATE: {
                    ((AbstractContainerManager)this.getContainerManager()).clear();
                    ((AbstractContainerManager)this.getContainerManager()).startUpdate();
                    for (int i = 0; i < manager.count(); ++i) {
                        Object cont = manager.get(i);
                        Object report = ((ReportHandler)((Object)((AbstractContainer)cont).getPayload())).getReport();
                        ReportContainer rcont = ((ReportContainerManager)this.getContainerManager()).newContainer((Comparable)report);
                        rcont.setID(((NamedContainer)cont).getID());
                        ((AbstractContainerManager)this.getContainerManager()).add((ReportContainer)rcont);
                    }
                    ((AbstractContainerManager)this.getContainerManager()).finishUpdate();
                    break;
                }
                case SEARCH: {
                    ((AbstractContainerManager)this.getContainerManager()).clear();
                    ((AbstractContainerManager)this.getContainerManager()).startUpdate();
                    for (int i = 0; i < manager.count(); ++i) {
                        Object cont = manager.get(i);
                        Object report = ((ReportHandler)((Object)((AbstractContainer)cont).getPayload())).getReport();
                        ReportContainer rcont = ((ReportContainerManager)this.getContainerManager()).newContainer((Comparable)report);
                        rcont.setID(((NamedContainer)cont).getID());
                        ((AbstractContainerManager)this.getContainerManager()).add((ReportContainer)rcont);
                    }
                    ((AbstractContainerManager)this.getContainerManager()).finishUpdate();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled data change event: " + (Object)((Object)e.getType()));
                }
            }
        }

        protected Table newTable(Model model) {
            return new Table(model);
        }

        protected Model newModel(Report report) {
            return new Model(report);
        }

        protected Table getTable(int index) {
            Table result;
            ReportContainer cont = (ReportContainer)((AbstractContainerManager)this.getContainerManager()).get(index);
            if (!cont.hasComponent()) {
                result = this.newTable(this.newModel(cont.getReport()));
                result.setDataContainerPanel(this.getDataContainerPanel());
                cont.setComponent(result);
            }
            result = (Table)cont.getComponent();
            return result;
        }

        protected String getBorderTitle(int index) {
            return ((ReportContainer)((AbstractContainerManager)this.getContainerManager()).get(index)).getDisplayID();
        }

        protected void selectTable(final int index) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    m_ReportContainerList.getTable().getSelectionModel().addSelectionInterval(index, index);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void showTable(int index) {
            Table table;
            if (index >= 0) {
                table = this.getTable(index);
                table.search(this.m_SearchString, this.m_RegExp);
            } else {
                table = null;
            }
            this.m_PanelTable.removeAll();
            if (table != null) {
                this.m_PanelTable.add((Component)new BaseScrollPane(table), "Center");
                this.m_PanelTable.setBorder(BorderFactory.createTitledBorder(this.getBorderTitle(index)));
            } else {
                this.m_PanelTable.add((Component)new JPanel(), "Center");
                this.m_PanelTable.setBorder(BorderFactory.createEmptyBorder());
            }
            this.m_PanelTable.doLayout();
        }

        public Table getCurrentTable() {
            Table result = null;
            if (this.m_ReportContainerList.getTable().getSelectedRow() != -1) {
                result = this.getTable(this.m_ReportContainerList.getTable().getSelectedRow());
            }
            return result;
        }

        public int getSelectedRow() {
            return this.m_ReportContainerList.getTable().getSelectedRow();
        }

        public void setCurrentTable(int index) {
            if (index < 0) {
                return;
            }
            this.showTable(index);
            ContainerTable table = this.m_ReportContainerList.getTable();
            table.getSelectionModel().clearSelection();
            table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public static class Table
    extends SortableAndSearchableTable {
        private static final long serialVersionUID = -4065569582552285461L;
        protected DataContainerPanel m_DataContainerPanel;
        protected AbstractReportFileChooser m_FileChooser;
        protected AbstractDatabaseConnection m_DatabaseConnection;
        protected String[] m_PopupActions;

        public Table() {
            this((Report)null);
        }

        public Table(Report report) {
            this(new Model(report));
        }

        public Table(TableModel model) {
            super(model);
        }

        @Override
        protected void initGUI() {
            super.initGUI();
            this.m_DataContainerPanel = null;
            this.m_FileChooser = this.newReportFileChooser();
            this.m_DatabaseConnection = DatabaseConnection.getSingleton();
            this.m_PopupActions = this.getDefaultPopupActions();
            this.setSelectionMode(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int[] rows;
                    JPopupMenu menu;
                    if (MouseUtils.isRightClick(e) && (menu = this.getPopupMenu(rows = this.getSelectedRowCount() < 1 ? new int[]{this.rowAtPoint(e.getPoint())} : this.getSelectedRows())) != null) {
                        e.consume();
                        menu.show(this, e.getX(), e.getY());
                    }
                    if (!e.isConsumed()) {
                        super.mouseClicked(e);
                    }
                }
            });
        }

        protected AbstractReportFileChooser newReportFileChooser() {
            return new DefaultReportFileChooser();
        }

        protected String[] getDefaultPopupActions() {
            return new String[]{CopyFieldName.class.getName(), CopyFieldValue.class.getName(), ModifyValue.class.getName(), ViewValue.class.getName(), "-", RemoveField.class.getName(), ExcludedFlag.class.getName(), AddField.class.getName(), "-", SaveReport.class.getName(), PrintReport.class.getName()};
        }

        public void setPopupActions(String[] value) {
            this.m_PopupActions = value;
        }

        public String[] getPopupActions() {
            return this.m_PopupActions;
        }

        @Override
        protected boolean initialUseOptimalColumnWidths() {
            return true;
        }

        @Override
        protected boolean initialSortNewTableModel() {
            return true;
        }

        @Override
        protected TableModel createDefaultDataModel() {
            return new Model(null);
        }

        public void setReport(Report value) {
            Model model = new Model(value);
            model.setNumDecimals(this.getNumDecimals());
            this.setUnsortedModel(model, true);
        }

        public Report getReport() {
            return ((Model)this.getUnsortedModel()).getReport();
        }

        public void setDataContainerPanel(DataContainerPanel value) {
            this.m_DataContainerPanel = value;
            if (this.m_DataContainerPanel != null) {
                this.m_DatabaseConnection = this.m_DataContainerPanel.getDatabaseConnection();
            }
        }

        public DataContainerPanel getDataContainerPanel() {
            return this.m_DataContainerPanel;
        }

        public ReportProvider getReportProvider() {
            return null;
        }

        public AbstractReportFileChooser getFileChooser() {
            return this.m_FileChooser;
        }

        public AbstractField getFieldAt(int row) {
            String field = "" + this.getValueAt(row, 0);
            if (field.indexOf(" | ") > -1) {
                field = field.replace(" | ", "\t");
            }
            String type = "" + this.getValueAt(row, 1);
            Field result = new Field(field, DataType.valueOf((AbstractOption)null, type));
            return result;
        }

        protected JPopupMenu getPopupMenu(int[] rows) {
            JPopupMenu result = null;
            if (rows.length > 0 && rows[0] > -1) {
                result = AbstractTableAction.createPopup(this.m_PopupActions, this, rows);
            }
            return result;
        }

        public void setNumDecimals(int value) {
            if (this.getUnsortedModel() instanceof Model) {
                ((Model)this.getUnsortedModel()).setNumDecimals(value);
            }
        }

        public int getNumDecimals() {
            if (this.getUnsortedModel() instanceof Model) {
                return ((Model)this.getUnsortedModel()).getNumDecimals();
            }
            return -1;
        }
    }

    public static class Model
    extends AbstractBaseTableModel
    implements CustomSearchTableModel {
        private static final long serialVersionUID = -6741006047295351384L;
        protected Report m_Report;
        protected List<AbstractField> m_Fields;
        protected int m_NumDecimals;

        public Model() {
            this(null);
        }

        public Model(Report report) {
            this.m_Report = report;
            this.m_Fields = this.m_Report != null ? this.m_Report.getFields() : new ArrayList<AbstractField>();
            this.m_NumDecimals = -1;
        }

        public Report getReport() {
            return this.m_Report;
        }

        @Override
        public int getRowCount() {
            return this.m_Fields.size();
        }

        @Override
        public int getColumnCount() {
            if (this.m_Report == null) {
                return 0;
            }
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Type";
            }
            return "Value";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = null;
            if (this.m_Report != null) {
                AbstractField field = this.m_Fields.get(row);
                result = column == 0 ? field.toDisplayString() : (column == 1 ? field.getDataType().toString() : (field.getDataType() == DataType.NUMERIC && this.m_NumDecimals > -1 ? Utils.doubleToString(this.m_Report.getDoubleValue(field), this.m_NumDecimals) : this.m_Report.getStringValue(field)));
            }
            return result;
        }

        public Class getColumnClass(int column) {
            Class result = column == 2 ? Object.class : String.class;
            return result;
        }

        @Override
        public boolean isSearchMatch(SearchParameters params, int row) {
            return params.matches(this.m_Fields.get(row).getName());
        }

        public void setNumDecimals(int value) {
            if (value >= -1) {
                this.m_NumDecimals = value;
                this.fireTableDataChanged();
            } else {
                System.err.println("Number of decimals need to be >= -1, provided: " + value);
            }
        }

        public int getNumDecimals() {
            return this.m_NumDecimals;
        }
    }
}

