/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.flow.core.Actor;
import adams.gui.visualization.core.PaintletWithFixedXRange;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.DotPaintlet;
import adams.gui.visualization.sequence.PaintletWithFixedYRange;

public class PaintletWithFixedXYRange
extends PaintletWithFixedYRange
implements PaintletWithFixedXRange {
    private static final long serialVersionUID = -7452372971179139015L;
    protected double m_MinX;
    protected double m_MaxX;
    protected Actor m_Actor;

    @Override
    public String globalInfo() {
        return "Meta-paintlet that uses a fixed X and Y ranges (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-x", "minX", 0.0, null, null);
        this.m_OptionManager.add("max-x", "maxX", 1000.0, null, null);
    }

    @Override
    protected void initialize() {
        this.setPaintlet(this.getDefaultPaintlet());
        super.initialize();
    }

    @Override
    protected AbstractXYSequencePaintlet getDefaultPaintlet() {
        return new DotPaintlet();
    }

    public void setMinX(double value) {
        this.m_MinX = value;
        this.memberChanged(true);
    }

    public double getMinX() {
        return this.m_MinX;
    }

    @Override
    public double getMinimumX() {
        return this.m_MinX;
    }

    public String minXTipText() {
        return "The minimum value for the X range.";
    }

    public void setMaxX(double value) {
        this.m_MaxX = value;
        this.memberChanged(true);
    }

    public double getMaxX() {
        return this.m_MaxX;
    }

    @Override
    public double getMaximumX() {
        return this.m_MaxX;
    }

    public String maxXTipText() {
        return "The maximum value for the X range.";
    }
}

