/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.db.AbstractDatabaseConnection;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.ParameterPanelPage;

public abstract class AbstractDatabaseConnectionPage
extends ParameterPanelPage {
    private static final long serialVersionUID = -7633802524155866313L;
    public static final String CONNECTION_URL = "connectionURL";
    public static final String CONNECTION_USER = "connectionUser";
    public static final String CONNECTION_PASSWORD = "connectionPassword";

    public AbstractDatabaseConnectionPage() {
        this("Connection");
    }

    public AbstractDatabaseConnectionPage(String pageName) {
        this.setPageName(pageName);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setDescription("Please enter the database connection parameters.\nA JDBC connection URL has the following format:\n  jdbc:<protocol>://<url or ip>[:port]/[database]\nFor instance, a MySQL database looks like this:\n  jdbc:mysql://localhost:3306/cms");
        this.getParameterPanel().addPropertyType(CONNECTION_URL, PropertiesParameterPanel.PropertyType.STRING);
        this.getParameterPanel().setLabel(CONNECTION_URL, "JDBC URL");
        this.getParameterPanel().addPropertyType(CONNECTION_USER, PropertiesParameterPanel.PropertyType.STRING);
        this.getParameterPanel().setLabel(CONNECTION_USER, "User");
        this.getParameterPanel().addPropertyType(CONNECTION_PASSWORD, PropertiesParameterPanel.PropertyType.PASSWORD);
        this.getParameterPanel().setLabel(CONNECTION_PASSWORD, "Password");
        this.getParameterPanel().setPropertyOrder(new String[]{CONNECTION_URL, CONNECTION_USER, CONNECTION_PASSWORD});
        AbstractDatabaseConnection conn = this.getDefaultDatabaseConnection();
        Properties props = new Properties();
        props.setProperty(CONNECTION_URL, conn.getURL());
        props.setProperty(CONNECTION_USER, conn.getUser());
        props.setPassword(CONNECTION_PASSWORD, conn.getPassword());
        this.setProperties(props);
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    public static class DatabaseConnectionPageCheck
    implements PageCheck<AbstractDatabaseConnectionPage> {
        private static final long serialVersionUID = 5859663043469959157L;

        @Override
        public boolean checkPage(AbstractDatabaseConnectionPage page) {
            AbstractDatabaseConnection conn = page.getDatabaseConnection();
            try {
                return conn.connect();
            }
            catch (Exception e) {
                System.err.println("Failed to connect!");
                e.printStackTrace();
                return false;
            }
        }
    }
}

