/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.logging.LoggingSupporter;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextPane;
import adams.gui.wizard.DummyPageCheck;
import adams.gui.wizard.DummyProceedAction;
import adams.gui.wizard.PageCheck;
import adams.gui.wizard.ProceedAction;
import adams.gui.wizard.WizardPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;

public abstract class AbstractWizardPage
extends BasePanel
implements LoggingSupporter {
    private static final long serialVersionUID = 391442213775313771L;
    protected WizardPane m_Owner;
    protected String m_PageName;
    protected BaseTextPane m_TextDescription;
    protected BaseScrollPane m_ScrollPaneDescription;
    protected PageCheck m_PageCheck;
    protected ProceedAction m_ProceedAction;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PageName = "Page";
        this.m_PageCheck = new DummyPageCheck();
        this.m_ProceedAction = new DummyProceedAction();
        this.m_Owner = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextDescription = new BaseTextPane();
        this.m_TextDescription.setEditable(false);
        this.setDescriptionHeight(100);
        this.m_ScrollPaneDescription = new BaseScrollPane(this.m_TextDescription);
        this.add((Component)this.m_ScrollPaneDescription, "North");
    }

    public void setOwner(WizardPane value) {
        this.m_Owner = value;
    }

    public WizardPane getOwner() {
        return this.m_Owner;
    }

    public void setPageName(String value) {
        this.m_PageName = value;
    }

    public String getPageName() {
        return this.m_PageName;
    }

    public void setDescription(String value) {
        this.setDescription(value, value.toLowerCase().indexOf("<html>") > -1);
    }

    public void setDescription(String value, boolean isHtml) {
        if (isHtml) {
            this.m_TextDescription.setEditorKit(new HTMLEditorKit());
        } else {
            this.m_TextDescription.setEditorKit(new StyledEditorKit());
        }
        this.m_TextDescription.setText(value);
    }

    public String getDescription() {
        return this.m_TextDescription.getText();
    }

    public void setDescriptionHeight(int value) {
        this.m_TextDescription.setPreferredSize(new Dimension(0, value));
    }

    public int getDescriptionHeight() {
        return this.m_TextDescription.getPreferredSize().height;
    }

    public void setPageCheck(PageCheck value) {
        this.m_PageCheck = value;
    }

    public PageCheck getPageCheck() {
        return this.m_PageCheck;
    }

    public void setProceedAction(ProceedAction value) {
        this.m_ProceedAction = value;
    }

    public ProceedAction getProceedAction() {
        return this.m_ProceedAction;
    }

    public boolean canProceed() {
        return this.m_PageCheck.checkPage(this);
    }

    public void updateButtons() {
        if (this.m_Owner != null) {
            this.m_Owner.updateButtons();
        }
    }

    public abstract Properties getProperties();

    @Override
    public Logger getLogger() {
        return this.m_Owner.getLogger();
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.m_Owner.isLoggingEnabled();
    }
}

