/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.wizard;

import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.env.Environment;
import adams.gui.core.BaseFrame;
import adams.gui.core.BaseList;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.wizard.AbstractWizardPage;
import adams.gui.wizard.FinalPage;
import adams.gui.wizard.ListPage;
import adams.gui.wizard.ParameterPanelPage;
import adams.gui.wizard.PropertySheetPanelPage;
import adams.gui.wizard.SelectDirectoryPage;
import adams.gui.wizard.SelectFilePage;
import adams.gui.wizard.SelectMultipleDirectoriesPage;
import adams.gui.wizard.SelectMultipleFilesPage;
import adams.gui.wizard.StartPage;
import adams.gui.wizard.TextAreaPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WizardPane
extends BasePanel
implements LoggingSupporter {
    private static final long serialVersionUID = 887135856139374858L;
    public static final String ACTION_CANCEL = "Cancel";
    public static final String ACTION_FINISH = "Finish";
    protected Logger m_Logger;
    protected String m_ID;
    protected DefaultListModel<String> m_ModelNames;
    protected BaseList m_ListNames;
    protected BaseScrollPane m_ScrollPaneNames;
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PageComponent;
    protected HashMap<String, AbstractWizardPage> m_PageLookup;
    protected List<String> m_PageOrder;
    protected int m_SelectedPage;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonBack;
    protected JButton m_ButtonNext;
    protected JButton m_ButtonCancelFinish;
    protected HashSet<ActionListener> m_ActionListeners;
    protected String m_CustomFinishText;

    public WizardPane() {
        this("");
    }

    public WizardPane(String id) {
        this.m_ID = id;
        this.m_Logger = null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PageLookup = new HashMap();
        this.m_PageOrder = new ArrayList<String>();
        this.m_SelectedPage = -1;
        this.m_ActionListeners = new HashSet();
        this.m_CustomFinishText = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setDividerLocation(200);
        this.m_SplitPane.setOneTouchExpandable(false);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_ModelNames = new DefaultListModel();
        this.m_ListNames = new BaseList((ListModel)this.m_ModelNames);
        this.m_ListNames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WizardPane.this.m_ListNames.setSelectedIndex(WizardPane.this.m_SelectedPage);
            }
        });
        this.m_ScrollPaneNames = new BaseScrollPane(this.m_ListNames);
        this.m_SplitPane.setLeftComponent(this.m_ScrollPaneNames);
        this.m_PageComponent = new JPanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PageComponent);
        this.m_PanelButtons = new JPanel(new FlowLayout(2));
        this.add((Component)this.m_PanelButtons, "South");
        this.m_ButtonBack = new JButton("Back");
        this.m_ButtonBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardPane.this.setSelectedPage(WizardPane.this.getSelectedIndex() - 1);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonBack);
        this.m_ButtonNext = new JButton("Next");
        this.m_ButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWizardPage currPage = WizardPane.this.getPageAt(WizardPane.this.getSelectedIndex());
                AbstractWizardPage nextPage = WizardPane.this.getPageAt(WizardPane.this.getSelectedIndex() + 1);
                if (currPage.getProceedAction() != null) {
                    currPage.getProceedAction().onProceed(currPage, nextPage);
                }
                WizardPane.this.setSelectedPage(WizardPane.this.getSelectedIndex() + 1);
            }
        });
        this.m_PanelButtons.add(this.m_ButtonNext);
        this.m_ButtonCancelFinish = new JButton("");
        this.m_ButtonCancelFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = WizardPane.this.m_ButtonCancelFinish.getText().equals(WizardPane.ACTION_CANCEL) ? WizardPane.ACTION_CANCEL : WizardPane.ACTION_FINISH;
                WizardPane.this.notifyActionListeners(new ActionEvent(this, 1001, action));
            }
        });
        this.m_PanelButtons.add(this.m_ButtonCancelFinish);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    public String getID() {
        return this.m_ID;
    }

    public BaseSplitPane getSplitPane() {
        return this.m_SplitPane;
    }

    @Override
    public void removeAll() {
        this.m_PageOrder.clear();
        this.m_PageLookup.clear();
        this.m_ModelNames.clear();
        this.m_SelectedPage = -1;
    }

    public void addPage(AbstractWizardPage page) {
        page.setOwner(this);
        this.m_PageLookup.put(page.getPageName(), page);
        if (this.m_PageOrder.contains(page.getPageName())) {
            this.m_PageOrder.remove(page.getPageName());
        }
        this.m_PageOrder.add(page.getPageName());
        if (this.m_ModelNames.contains(page.getPageName())) {
            this.m_ModelNames.removeElement(page.getPageName());
        }
        this.m_ModelNames.addElement(page.getPageName());
        if (this.m_SelectedPage == -1) {
            this.setSelectedPage(0);
        } else {
            this.updateButtons();
        }
    }

    public void removePageAt(int index) {
        if (index < 0 || index >= this.m_PageOrder.size()) {
            return;
        }
        String name = this.m_PageOrder.get(index);
        this.m_PageComponent.removeAll();
        this.m_PageOrder.remove(index);
        AbstractWizardPage page = this.m_PageLookup.remove(name);
        if (page != null) {
            page.setOwner(null);
        }
        this.m_ModelNames.removeElement(name);
        if (index == this.m_SelectedPage && this.m_PageOrder.size() > 0) {
            if (this.m_SelectedPage == this.m_PageOrder.size()) {
                --this.m_SelectedPage;
            }
            this.m_ListNames.setSelectedIndex(this.m_SelectedPage);
        }
        this.updateButtons();
    }

    public int getSelectedIndex() {
        return this.m_SelectedPage;
    }

    public AbstractWizardPage getSelectedPage() {
        if (this.m_SelectedPage == -1) {
            return null;
        }
        return this.m_PageLookup.get(this.m_PageOrder.get(this.m_SelectedPage));
    }

    public void setSelectedPage(int index) {
        this.m_PageComponent.removeAll();
        this.m_SelectedPage = index;
        this.m_ListNames.setSelectedIndex(index);
        this.m_PageComponent.add(this.m_PageLookup.get(this.m_PageOrder.get(this.m_SelectedPage)));
        this.invalidate();
        this.validate();
        this.repaint();
        this.updateButtons();
    }

    public int getPageCount() {
        return this.m_PageLookup.size();
    }

    public AbstractWizardPage getPageAt(int index) {
        return this.m_PageLookup.get(this.m_PageOrder.get(index));
    }

    public Properties getProperties(boolean usePrefix) {
        Properties result = new Properties();
        for (String name : this.m_PageOrder) {
            AbstractWizardPage page = this.m_PageLookup.get(name);
            Properties sub = page.getProperties();
            if (usePrefix) {
                result.add(sub, page.getPageName() + ".");
                continue;
            }
            result.add(sub);
        }
        return result;
    }

    public void updateButtons() {
        AbstractWizardPage current = this.getSelectedPage();
        this.m_ButtonBack.setEnabled(this.m_SelectedPage > 0);
        this.m_ButtonNext.setEnabled(current != null && this.m_SelectedPage < this.getPageCount() - 1 && current.canProceed());
        this.m_ButtonCancelFinish.setEnabled(true);
        if (this.m_SelectedPage == this.getPageCount() - 1) {
            this.m_ButtonCancelFinish.setText(this.m_CustomFinishText == null ? ACTION_FINISH : this.m_CustomFinishText);
        } else {
            this.m_ButtonCancelFinish.setText(ACTION_CANCEL);
        }
    }

    public void addActionListener(ActionListener l) {
        this.m_ActionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.m_ActionListeners.remove(l);
    }

    protected void notifyActionListeners(ActionEvent e) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.m_ActionListeners.toArray(new ActionListener[this.m_ActionListeners.size()])) {
            listener.actionPerformed(e);
        }
    }

    public void setCustomFinishText(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        this.m_CustomFinishText = value;
    }

    public String getCustomFinishText() {
        return this.m_CustomFinishText;
    }

    @Override
    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = LoggingHelper.getLogger(this.getID().isEmpty() ? this.getClass().getName() : this.getClass().getName() + "/" + this.getID());
            this.m_Logger.setLevel(Level.INFO);
            this.m_Logger.removeHandler(LoggingHelper.getDefaultHandler());
            this.m_Logger.addHandler(LoggingHelper.getDefaultHandler());
            this.m_Logger.setUseParentHandlers(false);
        }
        return this.m_Logger;
    }

    @Override
    public boolean isLoggingEnabled() {
        return true;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        final WizardPane wizard = new WizardPane();
        wizard.addPage(new StartPage());
        ParameterPanelPage page = new ParameterPanelPage();
        page.setPageName("Parameters 1");
        page.setDescription("Here is the description of the first parameter page.\n\nAnother line.");
        page.getParameterPanel().addPropertyType("doublevalue", PropertiesParameterPanel.PropertyType.DOUBLE);
        page.getParameterPanel().setLabel("doublevalue", "Double value");
        page.getParameterPanel().addPropertyType("booleanvalue", PropertiesParameterPanel.PropertyType.BOOLEAN);
        page.getParameterPanel().setLabel("booleanvalue", "Boolean value");
        page.getParameterPanel().addPropertyType("stringlist", PropertiesParameterPanel.PropertyType.LIST);
        page.getParameterPanel().setLabel("stringlist", "String list");
        page.getParameterPanel().setList("stringlist", new String[]{"A", "B", "C"});
        page.getParameterPanel().addPropertyType("passwordvalue", PropertiesParameterPanel.PropertyType.PASSWORD);
        page.getParameterPanel().setLabel("passwordvalue", "Password value");
        page.getParameterPanel().addPropertyType("sqlvalue", PropertiesParameterPanel.PropertyType.SQL);
        page.getParameterPanel().setLabel("sqlvalue", "SQL value");
        Properties props = new Properties();
        props.setDouble("doublevalue", 1.234);
        props.setBoolean("booleanvalue", true);
        props.setProperty("stringlist", "B");
        props.setPassword("passwordvalue", new BasePassword("secret"));
        props.setProperty("sqlvalue", "select * from table1 where a < b");
        page.setProperties(props);
        page.setDescription("Here is the description of the first parameter page.\n\nAnother line.");
        wizard.addPage(page);
        page = new ParameterPanelPage();
        page.setDescription("<html><h3>More parameters</h3>Here is the description of the 2nd parameter page.<br><br>Another line.");
        page.setPageName("Parameters 2");
        wizard.addPage(page);
        page = new ParameterPanelPage();
        page.setPageName("Parameters 3");
        page.setDescription("Nothing here.");
        wizard.addPage(page);
        PropertySheetPanelPage shpage = new PropertySheetPanelPage("Reader");
        shpage.setDescription("<html><h3>Object properties</h3>Here you can change all properties of the " + CsvSpreadSheetReader.class.getName() + ".");
        shpage.setTarget(new CsvSpreadSheetReader());
        wizard.addPage(shpage);
        ListPage lpage = new ListPage();
        lpage.setPageName("List");
        lpage.setDescription("Select any number of items from the list below");
        lpage.setValues(new String[]{"1", "2", "3", "4", "5"});
        lpage.setSelectionMode(2);
        lpage.setSelectedValues(new String[]{"3", "5"});
        wizard.addPage(lpage);
        SelectFilePage selpage = new SelectFilePage();
        selpage.setPageName("Select file");
        selpage.setDescription("Please select any existing file by clicking on the '...' button.");
        selpage.addChoosableFileFilter(new ExtensionFileFilter("Log files", "log"));
        ExtensionFileFilter filter = new ExtensionFileFilter("Text files", "txt");
        selpage.addChoosableFileFilter(filter);
        selpage.setFileFilter(filter);
        wizard.addPage(selpage);
        SelectMultipleFilesPage selmpage = new SelectMultipleFilesPage();
        selmpage.setPageName("Select multiple files");
        selmpage.setDescription("Please select as many files as you like.");
        selmpage.addChoosableFileFilter(new ExtensionFileFilter("Log files", "log"));
        filter = new ExtensionFileFilter("Text files", "txt");
        selmpage.addChoosableFileFilter(filter);
        selmpage.setFileFilter(filter);
        wizard.addPage(selmpage);
        SelectDirectoryPage seldir = new SelectDirectoryPage();
        seldir.setPageName("Select directory");
        seldir.setDescription("Please select any existing file by clicking on the '...' button.");
        wizard.addPage(seldir);
        SelectMultipleDirectoriesPage selmdir = new SelectMultipleDirectoriesPage();
        selmdir.setPageName("Select multiple directories");
        selmdir.setDescription("Please select as many directories as you like.");
        wizard.addPage(selmdir);
        TextAreaPage textpage = new TextAreaPage("Free text");
        textpage.setDescription("Please enter some text");
        textpage.setText("blah\nblah\nblah");
        wizard.addPage(textpage);
        wizard.addPage(new FinalPage());
        final BaseFrame frame = new BaseFrame("Example Wizard");
        wizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e.getActionCommand());
                System.out.println(wizard.getProperties(true));
                frame.setVisible(false);
                frame.dispose();
            }
        });
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)wizard, "Center");
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

