/*
 * Decompiled with CFR 0.152.
 */
package adams.tools;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.tools.AbstractScriptedTool;
import adams.tools.AbstractTool;

public class Scripted
extends AbstractScriptedTool {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractTool m_ToolObject;
    protected AbstractScriptingHandler m_Handler;

    @Override
    public String globalInfo() {
        return "A tool that uses any scripting handler for processing the data with a script located in the specified file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractTool.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected void preRun() {
        super.preRun();
        this.m_ToolObject = (AbstractTool)this.m_ScriptObject;
    }

    @Override
    protected void doRun() {
        this.m_ToolObject.run();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ToolObject = null;
    }
}

