/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Properties;

public abstract class AbstractPropertiesHandler
implements Serializable {
    private static final long serialVersionUID = -7969703434827836907L;

    protected abstract String getFilename();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveProperties(Properties props) {
        boolean result = false;
        String filename = this.getFilename();
        BufferedWriter writer = null;
        try {
            File file = new File(this.getFilename());
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            writer = new BufferedWriter(new FileWriter(file));
            props.store(writer, null);
            writer.flush();
            result = true;
        }
        catch (Exception e) {
            System.err.println("Failed to save bookmarks to " + filename);
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties() {
        Properties result = new Properties();
        String filename = this.getFilename();
        BufferedReader reader = null;
        try {
            File file = new File(filename);
            if (file.exists() && !file.isDirectory()) {
                reader = new BufferedReader(new FileReader(filename));
                result.load(reader);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load bookmarks from " + filename);
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }
}

