/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class PgsBorders {
    private static Border buttonBorder;
    private static Border textFieldBorder;
    private static Border componentBorder;
    private static Border toolBarBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getComponentBorder() {
        if (componentBorder == null) {
            componentBorder = new BorderUIResource.CompoundBorderUIResource(new ComponentBorder(), new BasicBorders.MarginBorder());
        }
        return componentBorder;
    }

    public static Border getToolBarBorder() {
        if (toolBarBorder == null) {
            toolBarBorder = new BorderUIResource(new ToolBarBorder());
        }
        return toolBarBorder;
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    PgsUtils.drawVerticalBumps(g, 2, 4, c.getHeight() - 6);
                } else {
                    PgsUtils.drawHorizontalBumps(g, 4, 2, c.getWidth() - 6);
                }
            }
            if (((JToolBar)c).getOrientation() == 0) {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.setColor(UIManager.getColor("ToolBar.borderColor"));
                g.drawLine(0, h - 1, w, h - 1);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            Insets margin;
            newInsets.left = 2;
            newInsets.top = 1;
            newInsets.bottom = 2;
            newInsets.right = 2;
            if (((JToolBar)c).isFloatable()) {
                if (((JToolBar)c).getOrientation() == 0) {
                    if (c.getComponentOrientation().isLeftToRight()) {
                        newInsets.left = 16;
                    } else {
                        newInsets.right = 16;
                    }
                } else {
                    newInsets.top = 16;
                }
            }
            if ((margin = ((JToolBar)c).getMargin()) != null) {
                newInsets.left += margin.left;
                newInsets.top += margin.top;
                newInsets.right += margin.right;
                newInsets.bottom += margin.bottom;
            }
            return newInsets;
        }
    }

    private static class ComponentBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private ComponentBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.isEnabled()) {
                PgsUtils.drawButtonBorder(g, x, y, w, h);
            } else {
                PgsUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ComponentBorder.INSETS.top;
            newInsets.left = ComponentBorder.INSETS.left;
            newInsets.bottom = ComponentBorder.INSETS.bottom;
            newInsets.right = ComponentBorder.INSETS.right;
            return newInsets;
        }
    }

    private static class TextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 1);

        private TextFieldBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.isEnabled()) {
                boolean isEditable = c instanceof JTextComponent && ((JTextComponent)c).isEditable() || c instanceof JComboBox && ((JComboBox)c).isEditable();
                boolean hasFocus = c.hasFocus();
                if (c instanceof JComboBox) {
                    JComboBox comboBox = (JComboBox)c;
                    hasFocus = comboBox.isEditable() && comboBox.getEditor().getEditorComponent().hasFocus();
                }
                PgsUtils.drawButtonBorder(g, x, y, w - 1, h - 1, 2, 2, hasFocus && isEditable ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlDarkShadow());
            } else {
                PgsUtils.drawDisabledBorder(g, x, y, w - 1, h - 1, 2, 2);
            }
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = TextFieldBorder.INSETS.top;
            newInsets.left = TextFieldBorder.INSETS.left;
            newInsets.bottom = TextFieldBorder.INSETS.bottom;
            newInsets.right = TextFieldBorder.INSETS.right;
            return newInsets;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static final Insets INSETS = new Insets(3, 4, 3, 4);
        protected static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

        private ButtonBorder() {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isRollover() && PlafOptions.isPaintRolloverButtonBorder()) {
                    PgsUtils.drawRolloverButtonBorder(g, x, y, w, h);
                } else {
                    PgsUtils.drawButtonBorder(g, x, y, w, h);
                }
            } else {
                PgsUtils.drawDisabledBorder(g, x, y, w - 1, h - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            if (((AbstractButton)c).isBorderPainted()) {
                return INSETS;
            }
            return NO_INSETS;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (((AbstractButton)c).isBorderPainted()) {
                return this.getBorderInsets(c, newInsets, INSETS);
            }
            return this.getBorderInsets(c, newInsets, NO_INSETS);
        }

        public Insets getBorderInsets(Component c, Insets newInsets, Insets oldInsets) {
            newInsets.top = oldInsets.top;
            newInsets.left = oldInsets.left;
            newInsets.bottom = oldInsets.bottom;
            newInsets.right = oldInsets.right;
            return newInsets;
        }
    }

    public static class Generic
    extends AbstractBorder
    implements UIResource {
        private Insets insets;
        private Color color;

        public Generic(Insets insets, Color color) {
            this.insets = insets;
            this.color = color;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            if (this.insets.left != 0) {
                g.fillRect(x, y, x + this.insets.left, y + height);
            }
            if (this.insets.right != 0) {
                g.fillRect(x + width - this.insets.right, y, x + width, y + height);
            }
            if (this.insets.top != 0) {
                g.fillRect(x, y, x + width, x + this.insets.top);
            }
            if (this.insets.bottom != 0) {
                g.fillRect(x, y + height - this.insets.bottom, x + width, y + height);
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            return insets;
        }
    }
}

